//Falcon2-11B DATASET v1.0 Category: Traffic Flow Simulation ; Style: synchronous
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

int main()
{
    int car_count = 5;
    int road_length = 50;
    int max_speed = 10;
    int car_speed[car_count];
    int road_status[road_length];
    int current_car = 0;
    int current_road = 0;

    srand(time(NULL));
    for(int i=0; i<car_count; i++)
    {
        car_speed[i] = rand() % (max_speed + 1) - 1;
    }
    for(int i=0; i<road_length; i++)
    {
        road_status[i] = 1;
    }

    while(current_car < car_count && current_road < road_length)
    {
        printf("Car %d at position %d: ", current_car+1, current_road+1);

        if(car_speed[current_car] > 0)
        {
            printf("Moving forward at %d mph\n", car_speed[current_car]);
        }
        else if(car_speed[current_car] < 0)
        {
            printf("Reversing at %d mph\n", abs(car_speed[current_car]));
        }
        else
        {
            printf("Stopped\n");
        }

        if(current_road + car_speed[current_car] < road_length)
        {
            road_status[current_road + car_speed[current_car]] = 0;
            current_road += car_speed[current_car];
        }
        else
        {
            current_car = (current_car + 1) % car_count;
            current_road = (current_road + 1) % road_length;
        }
    }

    return 0;
}