//Falcon-180B DATASET v1.0 Category: Mortgage Calculator ; Style: distributed
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_VALUE_LENGTH 64

typedef struct {
    char value[MAX_VALUE_LENGTH];
    double amount;
} Value;

typedef struct {
    char name[MAX_VALUE_LENGTH];
    Value principal;
    Value interest_rate;
    Value term_years;
    Value down_payment;
} Mortgage;

void print_value(Value value) {
    printf("%.2f", value.amount);
}

void read_value(Value* value) {
    printf("Enter value: ");
    scanf("%s", value->value);
    value->amount = atof(value->value);
}

void print_mortgage(Mortgage mortgage) {
    printf("Principal: ");
    print_value(mortgage.principal);
    printf("\n");

    printf("Interest rate: ");
    print_value(mortgage.interest_rate);
    printf("\n");

    printf("Term years: ");
    print_value(mortgage.term_years);
    printf("\n");

    printf("Down payment: ");
    print_value(mortgage.down_payment);
    printf("\n");
}

void read_mortgage(Mortgage* mortgage) {
    printf("Enter mortgage name: ");
    scanf("%s", mortgage->name);

    printf("Enter principal value: ");
    read_value(&mortgage->principal);

    printf("Enter interest rate value: ");
    read_value(&mortgage->interest_rate);

    printf("Enter term years value: ");
    read_value(&mortgage->term_years);

    printf("Enter down payment value: ");
    read_value(&mortgage->down_payment);
}

void calculate_mortgage(Mortgage mortgage) {
    double monthly_interest_rate = mortgage.interest_rate.amount / 1200.0;
    double monthly_payment = (mortgage.principal.amount * monthly_interest_rate) / (1 - pow(1 + monthly_interest_rate, -mortgage.term_years.amount * 12));

    printf("Monthly payment: ");
    print_value(mortgage.principal);
    printf("\n");
}

int main() {
    Mortgage mortgage;
    read_mortgage(&mortgage);
    calculate_mortgage(mortgage);

    return 0;
}