//MISTRAL-7B DATASET v1.0 Category: CPU usage monitor ; Style: cheerful
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/sysinfo.h>

#define MIN(a, b) ((a) < (b) ? (a) : (b))

struct usage {
    long int utime;
    long int stime;
    long int maxrss;
    long int id;
};

void print_cpu_usage(struct usage prev, struct usage curr) {
    long int total_usage = (curr.utime + curr.stime) - (prev.utime + prev.stime);
    float cpu_percent = (float)total_usage / sysconf(_SC_CLK_TCK) * 100.0;
    printf("\n***** Yippee! CPU usage report *****\n");
    printf("Previous CPU usage: %.2f%%\n", prev.utime / sysconf(_SC_CLK_TCK) * 100.0);
    printf("Current CPU usage: %.2f%%\n", cpu_percent);
    printf("Total CPU usage since last report: %.2f%%\n", total_usage / sysconf(_SC_CLK_TCK) * 100.0);
}

int main() {
    struct usage prev, curr;
    int fd;
    char filename[] = "/proc/self/status";

    while (1) {
        fd = open(filename, O_RDONLY);
        if (fd < 0) {
            perror("Error opening file");
            exit(EXIT_FAILURE);
        }
        if (read(fd, &prev, sizeof(prev)) < 0) {
            perror("Error reading from file");
            close(fd);
            exit(EXIT_FAILURE);
        }
        close(fd);

        fd = open("/proc/self/statm", O_RDONLY);
        if (fd < 0) {
            perror("Error opening file");
            exit(EXIT_FAILURE);
        }
        read(fd, &curr.maxrss, sizeof(curr.maxrss));
        read(fd, &curr.id, sizeof(curr.id));
        close(fd);

        print_cpu_usage(prev, curr);
        sleep(1);
    }

    return 0;
}