//Code Llama-13B DATASET v1.0 Category: Medical Store Management System ; Style: optimized
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the structure for a medicine
typedef struct {
  char name[50];
  char category[50];
  int quantity;
  float price;
} Medicine;

// Define the structure for a customer
typedef struct {
  char name[50];
  int age;
  char gender[10];
  char address[100];
  char phone[15];
} Customer;

// Define the structure for an order
typedef struct {
  Medicine medicine;
  int quantity;
} Order;

// Function to add a medicine to the inventory
void addMedicine(Medicine* medicines, int* numMedicines, Medicine newMedicine) {
  medicines[*numMedicines] = newMedicine;
  (*numMedicines)++;
}

// Function to add a customer to the database
void addCustomer(Customer* customers, int* numCustomers, Customer newCustomer) {
  customers[*numCustomers] = newCustomer;
  (*numCustomers)++;
}

// Function to add an order to the database
void addOrder(Order* orders, int* numOrders, Order newOrder) {
  orders[*numOrders] = newOrder;
  (*numOrders)++;
}

// Function to display the inventory
void displayInventory(Medicine* medicines, int numMedicines) {
  for (int i = 0; i < numMedicines; i++) {
    printf("%s (%s): %d units available, $%.2f each\n", medicines[i].name, medicines[i].category, medicines[i].quantity, medicines[i].price);
  }
}

// Function to display the customers
void displayCustomers(Customer* customers, int numCustomers) {
  for (int i = 0; i < numCustomers; i++) {
    printf("%s (%d years old, %s, %s, %s)\n", customers[i].name, customers[i].age, customers[i].gender, customers[i].address, customers[i].phone);
  }
}

// Function to display the orders
void displayOrders(Order* orders, int numOrders) {
  for (int i = 0; i < numOrders; i++) {
    printf("%s (%d units, $%.2f total)\n", orders[i].medicine.name, orders[i].quantity, orders[i].medicine.price * orders[i].quantity);
  }
}

// Function to search for a medicine by name
int searchMedicine(Medicine* medicines, int numMedicines, char* name) {
  for (int i = 0; i < numMedicines; i++) {
    if (strcmp(medicines[i].name, name) == 0) {
      return i;
    }
  }
  return -1;
}

// Function to search for a customer by name
int searchCustomer(Customer* customers, int numCustomers, char* name) {
  for (int i = 0; i < numCustomers; i++) {
    if (strcmp(customers[i].name, name) == 0) {
      return i;
    }
  }
  return -1;
}

int main() {
  Medicine medicines[100];
  int numMedicines = 0;

  Customer customers[100];
  int numCustomers = 0;

  Order orders[100];
  int numOrders = 0;

  // Add some medicines to the inventory
  addMedicine(&medicines, &numMedicines, (Medicine){"Paracetamol", "Pain Reliever", 100, 10.00});
  addMedicine(&medicines, &numMedicines, (Medicine){"Ibuprofen", "Pain Reliever", 50, 12.00});
  addMedicine(&medicines, &numMedicines, (Medicine){"Acetaminophen", "Pain Reliever", 75, 8.00});

  // Add some customers to the database
  addCustomer(&customers, &numCustomers, (Customer){"John Doe", 35, "Male", "123 Main St", "555-555-5555"});
  addCustomer(&customers, &numCustomers, (Customer){"Jane Doe", 25, "Female", "456 Elm St", "555-555-5556"});
  addCustomer(&customers, &numCustomers, (Customer){"Bob Smith", 45, "Male", "789 Oak St", "555-555-5557"});

  // Add some orders to the database
  addOrder(&orders, &numOrders, (Order){medicines[0], 20});
  addOrder(&orders, &numOrders, (Order){medicines[1], 10});
  addOrder(&orders, &numOrders, (Order){medicines[2], 5});

  // Display the inventory
  displayInventory(medicines, numMedicines);

  // Display the customers
  displayCustomers(customers, numCustomers);

  // Display the orders
  displayOrders(orders, numOrders);

  // Search for a medicine by name
  int index = searchMedicine(medicines, numMedicines, "Ibuprofen");
  if (index != -1) {
    printf("Ibuprofen is at index %d\n", index);
  } else {
    printf("Ibuprofen not found\n");
  }

  // Search for a customer by name
  index = searchCustomer(customers, numCustomers, "Jane Doe");
  if (index != -1) {
    printf("Jane Doe is at index %d\n", index);
  } else {
    printf("Jane Doe not found\n");
  }

  return 0;
}