//Gemma-7B DATASET v1.0 Category: Pac-Man Game Clone ; Style: satisfied
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAP_WIDTH 20
#define MAP_HEIGHT 20

#define PAC_MAN_SIZE 5

typedef struct Pacman {
    int x;
    int y;
    int direction;
    int speed;
} Pacman;

Pacman pacman;

void drawMap() {
    for (int y = 0; y < MAP_HEIGHT; y++) {
        for (int x = 0; x < MAP_WIDTH; x++) {
            if (x == pacman.x && y == pacman.y) {
                printf("O");
            } else {
                printf(".");
            }
        }
        printf("\n");
    }
}

void movePacman() {
    switch (pacman.direction) {
        case 0:
            pacman.y--;
            break;
        case 1:
            pacman.x++;
            break;
        case 2:
            pacman.y++;
            break;
        case 3:
            pacman.x--;
            break;
    }

    if (pacman.x < 0) {
        pacman.x = 0;
    }
    if (pacman.x >= MAP_WIDTH - PAC_MAN_SIZE) {
        pacman.x = MAP_WIDTH - PAC_MAN_SIZE - 1;
    }
    if (pacman.y < 0) {
        pacman.y = 0;
    }
    if (pacman.y >= MAP_HEIGHT - PAC_MAN_SIZE) {
        pacman.y = MAP_HEIGHT - PAC_MAN_SIZE - 1;
    }
}

void main() {
    pacman.x = 5;
    pacman.y = 5;
    pacman.direction = 1;
    pacman.speed = 2;

    drawMap();
    movePacman();
    drawMap();

    time_t t = time(NULL);
    while (time(NULL) - t < 5) {
        movePacman();
        drawMap();
    }

    printf("GAME OVER!");
}