//Falcon-180B DATASET v1.0 Category: Subnet Calculator ; Style: standalone
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_SUBNETS 16
#define MAX_SUBNET_SIZE 32

typedef struct {
    char name[MAX_SUBNET_SIZE];
    int size;
    int num_hosts;
    int broadcast_addr;
    int first_addr;
    int last_addr;
} subnet_t;

int main() {
    int num_subnets;
    subnet_t subnets[MAX_SUBNETS];
    int i;

    printf("Enter the number of subnets: ");
    if (scanf("%d", &num_subnets)!= 1) {
        printf("Invalid input.\n");
        return 1;
    }

    for (i = 0; i < num_subnets; i++) {
        printf("Enter subnet %d name: ", i+1);
        scanf("%s", subnets[i].name);

        printf("Enter subnet %d size: ", i+1);
        if (scanf("%d", &subnets[i].size)!= 1) {
            printf("Invalid input.\n");
            return 1;
        }

        subnets[i].num_hosts = (int)pow(2, (double)subnets[i].size - 1) - 2;
        subnets[i].broadcast_addr = subnets[i].first_addr + subnets[i].num_hosts - 1;
        subnets[i].first_addr = (i * subnets[i].num_hosts) + 1;
        subnets[i].last_addr = subnets[i].first_addr + subnets[i].num_hosts - 1;
    }

    printf("\nSubnet Information:\n");
    for (i = 0; i < num_subnets; i++) {
        printf("Subnet %d:\n", i+1);
        printf("  Name: %s\n", subnets[i].name);
        printf("  Size: %d\n", subnets[i].size);
        printf("  Number of Hosts: %d\n", subnets[i].num_hosts);
        printf("  Broadcast Address: %d\n", subnets[i].broadcast_addr);
        printf("  First Address: %d\n", subnets[i].first_addr);
        printf("  Last Address: %d\n", subnets[i].last_addr);
        printf("\n");
    }

    return 0;
}