//Falcon2-11B DATASET v1.0 Category: Queue Implementation ; Style: Linus Torvalds
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_SIZE 10

typedef struct Node {
    int data;
    struct Node* next;
} Node;

typedef struct Queue {
    Node* front;
    Node* rear;
} Queue;

void enqueue(Queue* q, int data) {
    if (q->rear == NULL) {
        q->front = q->rear = malloc(sizeof(Node));
        q->front->data = data;
        q->front->next = NULL;
    } else {
        Node* newNode = malloc(sizeof(Node));
        newNode->data = data;
        newNode->next = NULL;

        q->rear->next = newNode;
        q->rear = newNode;
    }
}

int dequeue(Queue* q) {
    if (q->rear == NULL) {
        printf("Queue is empty!\n");
        return -1;
    }

    int data = q->front->data;

    if (q->front == q->rear) {
        free(q->front);
        q->front = q->rear = NULL;
    } else {
        q->front = q->front->next;
        free(q->rear);
        q->rear = q->front;
    }

    return data;
}

void printQueue(Queue* q) {
    Node* node = q->front;
    while (node!= NULL) {
        printf("%d ", node->data);
        node = node->next;
    }
    printf("\n");
}

int main() {
    Queue* q = malloc(sizeof(Queue));
    q->front = q->rear = NULL;

    enqueue(q, 1);
    enqueue(q, 2);
    enqueue(q, 3);

    printf("Queue: ");
    printQueue(q);

    printf("Dequeue: %d\n", dequeue(q));
    printf("Queue: ");
    printQueue(q);

    printf("Dequeue: %d\n", dequeue(q));
    printf("Queue: ");
    printQueue(q);

    return 0;
}