
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#define MAX_INPUT 1000
#define POSITIVE_WORDS 10
#define NEGATIVE_WORDS 10


const char *positive_words[POSITIVE_WORDS] = {
    "happy", "joy", "love", "fantastic", "great", 
    "amazing", "positive", "awesome", "wonderful", 
    "excited"
};

const char *negative_words[NEGATIVE_WORDS] = {
    "sad", "hate", "bad", "terrible", "awful", 
    "horrible", "negative", "angry", "disappointing", 
    "frustrated"
};


void to_lowercase(char *str) {
    for(int i = 0; str[i]; i++) {
        str[i] = tolower((unsigned char)str[i]);
    }
}


void analyze_sentiment(const char *input) {
    int positive_count = 0;
    int negative_count = 0;

    char *token = strtok(strdup(input), " ");
    
    while(token != NULL) {
        to_lowercase(token); 

        
        for(int i = 0; i < POSITIVE_WORDS; i++) {
            if(strcmp(token, positive_words[i]) == 0) {
                positive_count++;
                break;
            }
        }

        
        for(int i = 0; i < NEGATIVE_WORDS; i++) {
            if(strcmp(token, negative_words[i]) == 0) {
                negative_count++;
                break;
            }
        }

        token = strtok(NULL, " ");
    }

    
    if(positive_count > negative_count) {
        printf("Sentiment Analysis Result: Positive sentiment detected (%d positive words, %d negative words).\n", positive_count, negative_count);
    } else if(negative_count > positive_count) {
        printf("Sentiment Analysis Result: Negative sentiment detected (%d positive words, %d negative words).\n", positive_count, negative_count);
    } else {
        printf("Sentiment Analysis Result: Neutral sentiment detected (%d positive words, %d negative words).\n", positive_count, negative_count);
    }
}

int main() {
    char input[MAX_INPUT];

    printf("Welcome to the Creative C Sentiment Analysis Tool!\n");
    printf("Please enter a sentence to analyze its sentiment:\n");
    
    
    fgets(input, sizeof(input), stdin);
    
    
    input[strcspn(input, "\n")] = 0;

    
    analyze_sentiment(input);

    return 0;
}