//Falcon2-11B DATASET v1.0 Category: Bucket Sort Implementation ; Style: brave
#include <stdio.h>
#include <stdlib.h>

// Function to print an array
void printArray(int arr[], int size) {
    int i;
    for (i = 0; i < size; i++)
        printf("%d ", arr[i]);
    printf("\n");
}

// Function to perform bucket sort
void bucketSort(int arr[], int size) {
    int i, j, k, min_elem;
    int *arr_copy = (int*)malloc(size * sizeof(int)); // create a copy of the original array
    int *buckets[10]; // create an array of pointers to store buckets

    for (i = 0; i < 10; i++)
        buckets[i] = NULL;

    // Initialize buckets
    for (i = 0; i < size; i++) {
        min_elem = arr[i];
        j = 0;
        while (buckets[j]!= NULL && arr[j] < min_elem)
            j++;
        while (buckets[j]!= NULL && buckets[j][1] < min_elem) {
            min_elem = buckets[j][0];
            j++;
        }
        buckets[j] = (int*)malloc(sizeof(int)*(j+1));
        buckets[j][0] = min_elem;
        buckets[j][1] = i;
        j++;
    }

    // Sort each bucket
    for (i = 0; i < 10; i++) {
        if (buckets[i]!= NULL) {
            for (j = 1; j <= buckets[i][1]; j++) {
                k = buckets[i][j];
                arr_copy[k-1] = arr[i*10+j];
            }
        }
    }

    // Copy sorted array back to original array
    for (i = 0; i < size; i++) {
        arr[i] = arr_copy[i];
    }

    // Free memory
    for (i = 0; i < 10; i++) {
        if (buckets[i]!= NULL) {
            free(buckets[i]);
        }
    }
    free(arr_copy);
}

int main() {
    int arr[] = {5, 2, 1, 3, 4, 7, 6, 8, 9, 10};
    int size = sizeof(arr)/sizeof(arr[0]);
    printArray(arr, size);
    bucketSort(arr, size);
    printf("Sorted array: \n");
    printArray(arr, size);
    return 0;
}