
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <stdbool.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>

#define BUFFER_SIZE 1024

char* receiveMessage(int sock) {
    char message[BUFFER_SIZE];
    memset(message, 0, BUFFER_SIZE);
    if (recv(sock, message, BUFFER_SIZE, 0) < 0) {
        perror("\nError receiving message: ");
        exit(EXIT_FAILURE);
    }
    message[strcspn(message, "\r\n")] = 0; 
    char* response = (char*) malloc(strlen(message) + 1);
    strcpy(response, message);
    return response;
}

void sendMessage(int sock, char* message) {
    if (send(sock, message, strlen(message), 0) < 0) {
        perror("\nError sending message: ");
        exit(EXIT_FAILURE);
    }
}

int main(int argc, char* argv[]) {

    char* server = "localhost"; 
    char* username = "example@gmail.com"; 
    char* password = "password123"; 

    
    int sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
        perror("\nError creating socket: ");
        exit(EXIT_FAILURE);
    }

    
    struct sockaddr_in serverAddress;
    serverAddress.sin_family = AF_INET;
    serverAddress.sin_port = htons(143); 
    serverAddress.sin_addr.s_addr = inet_addr(server);

    
    if (connect(sock, (struct sockaddr*) &serverAddress, sizeof(serverAddress)) < 0) {
        perror("\nError connecting to server: ");
        exit(EXIT_FAILURE);
    }

    
    char* greeting = receiveMessage(sock);
    printf("%s\n", greeting);
    free(greeting);

    
    char* loginCommand = (char*) calloc(100, sizeof(char)); 
    sprintf(loginCommand, "LOGIN %s %s\r\n", username, password);
    sendMessage(sock, loginCommand);
    free(loginCommand);

    
    char* loginResponse = receiveMessage(sock);
    printf("%s\n", loginResponse);
    free(loginResponse);

    
    char* selectCommand = "SELECT INBOX\r\n";
    sendMessage(sock, selectCommand);

    
    char* selectResponse = receiveMessage(sock);
    printf("%s\n", selectResponse);
    free(selectResponse);

    
    char* listCommand = "FETCH 1:* BODY[HEADER.FIELDS (FROM TO SUBJECT)]\r\n";
    sendMessage(sock, listCommand);

    
    char* listResponse;
    while (true) {
        listResponse = receiveMessage(sock);
        printf("%s\n", listResponse);
        if (strstr(listResponse, "OK FETCH completed") != NULL) {
            break;
        }
        free(listResponse);
    }
    free(listResponse);

    
    char* logoutCommand = "LOGOUT\r\n";
    sendMessage(sock, logoutCommand);

    
    char* logoutResponse = receiveMessage(sock);
    printf("%s\n", logoutResponse);
    free(logoutResponse);

    
    close(sock);

    return 0;
}