//GPT-4o-mini DATASET v1.0 Category: Syntax parsing ; Style: Claude Shannon
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_TOKEN_LEN 64
#define MAX_NUM_TOKENS 128

typedef enum {
    TOKEN_IDENTIFIER,
    TOKEN_KEYWORD,
    TOKEN_NUMBER,
    TOKEN_OPERATOR,
    TOKEN_DELIMITER,
    TOKEN_END,
    TOKEN_UNKNOWN
} TokenType;

const char *keywords[] = {
    "auto", "break", "case", "char", "const", "continue",
    "default", "do", "double", "else", "enum", "extern",
    "float", "for", "goto", "if", "include", "int",
    "long", "register", "return", "short", "signed",
    "sizeof", "static", "struct", "switch", "typedef",
    "union", "unsigned", "void", "volatile", "while"
};

const char delimiters[] = "(),;{}[]";
const char operators[] = "+-*/=<>!&|^~";

typedef struct {
    char *value;
    TokenType type;
} Token;

Token* create_token(char *value, TokenType type) {
    Token *token = malloc(sizeof(Token));
    token->value = strdup(value);
    token->type = type;
    return token;
}

void free_token(Token *token) {
    free(token->value);
    free(token);
}

int is_keyword(const char *word) {
    for (int i = 0; i < sizeof(keywords) / sizeof(keywords[0]); i++) {
        if (strcmp(word, keywords[i]) == 0) {
            return 1;
        }
    }
    return 0;
}

int is_operator(char ch) {
    return strchr(operators, ch) != NULL;
}

int is_delimiter(char ch) {
    return strchr(delimiters, ch) != NULL;
}

void tokenize(const char *code, Token **tokens, int *token_count) {
    char current_token[MAX_TOKEN_LEN] = {0};
    int idx = 0;

    for (size_t i = 0; i < strlen(code); i++) {
        char ch = code[i];

        if (isspace(ch)) {
            if (idx > 0) {
                current_token[idx] = '\0';
                if (is_keyword(current_token)) {
                    tokens[(*token_count)++] = create_token(current_token, TOKEN_KEYWORD);
                } else if (isdigit(current_token[0])) {
                    tokens[(*token_count)++] = create_token(current_token, TOKEN_NUMBER);
                } else {
                    tokens[(*token_count)++] = create_token(current_token, TOKEN_IDENTIFIER);
                }
                idx = 0;
            }
        } else if (is_operator(ch)) {
            if (idx > 0) {
                current_token[idx] = '\0';
                tokens[(*token_count)++] = create_token(current_token, TOKEN_IDENTIFIER);
                idx = 0;
            }
            current_token[0] = ch;
            current_token[1] = '\0';
            tokens[(*token_count)++] = create_token(current_token, TOKEN_OPERATOR);
        } else if (is_delimiter(ch)) {
            if (idx > 0) {
                current_token[idx] = '\0';
                tokens[(*token_count)++] = create_token(current_token, TOKEN_IDENTIFIER);
                idx = 0;
            }
            current_token[0] = ch;
            current_token[1] = '\0';
            tokens[(*token_count)++] = create_token(current_token, TOKEN_DELIMITER);
        } else {
            current_token[idx++] = ch;
        }
    }

    if (idx > 0) {
        current_token[idx] = '\0';
        if (is_keyword(current_token)) {
            tokens[(*token_count)++] = create_token(current_token, TOKEN_KEYWORD);
        } else if (isdigit(current_token[0])) {
            tokens[(*token_count)++] = create_token(current_token, TOKEN_NUMBER);
        } else {
            tokens[(*token_count)++] = create_token(current_token, TOKEN_IDENTIFIER);
        }
    }

    tokens[(*token_count)] = create_token("", TOKEN_END); // End token
}

void print_tokens(Token **tokens, int token_count) {
    for (int i = 0; i < token_count; i++) {
        printf("Token: %-15s Type: ", tokens[i]->value);
        switch (tokens[i]->type) {
            case TOKEN_KEYWORD:    printf("KEYWORD\n"); break;
            case TOKEN_IDENTIFIER: printf("IDENTIFIER\n"); break;
            case TOKEN_NUMBER:     printf("NUMBER\n"); break;
            case TOKEN_OPERATOR:   printf("OPERATOR\n"); break;
            case TOKEN_DELIMITER:  printf("DELIMITER\n"); break;
            case TOKEN_END:        printf("END\n"); break;
            default:              printf("UNKNOWN\n"); break;
        }
    }
}

void free_tokens(Token **tokens, int token_count) {
    for (int i = 0; i < token_count; i++) {
        free_token(tokens[i]);
    }
}

int main() {
    const char *code = "int main() { return 0; }";
    Token *tokens[MAX_NUM_TOKENS];
    int token_count = 0;

    tokenize(code, tokens, &token_count);
    print_tokens(tokens, token_count);
    free_tokens(tokens, token_count);

    return 0;
}