//MISTRAL-7B DATASET v1.0 Category: Airport Baggage Handling Simulation ; Style: retro
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define MAX_BAGS 100
#define MAX_AIRCRAFTS 5

typedef struct {
    int id;
    char *destination;
} Bag;

typedef struct {
    int id;
    int num_bags;
    Bag bags[MAX_BAGS];
} Aircraft;

void generate_bags(Bag *bags, int num_bags);
void print_bags(Bag *bags, int num_bags);
void handle_bags(Aircraft *aircrafts, int num_aircrafts);

int main() {
    int num_aircrafts = 5;
    Aircraft aircrafts[MAX_AIRCRAFTS];

    srand(time(NULL));

    for (int i = 0; i < num_aircrafts; i++) {
        aircrafts[i].id = i + 1;
        generate_bags(aircrafts[i].bags, rand() % 10 + 1);
    }

    handle_bags(aircrafts, num_aircrafts);

    return 0;
}

void generate_bags(Bag *bags, int num_bags) {
    for (int i = 0; i < num_bags; i++) {
        bags[i].id = i + 1;
        bags[i].destination = malloc(20 * sizeof(char));
        sprintf(bags[i].destination, "DEST%d", rand() % 10 + 1);
    }
}

void print_bags(Bag *bags, int num_bags) {
    printf("Aircraft %d bags:\n", getpid());
    for (int i = 0; i < num_bags; i++) {
        printf("Bag %d: Destination %s\n", bags[i].id, bags[i].destination);
    }
}

void handle_bags(Aircraft *aircrafts, int num_aircrafts) {
    for (int i = 0; i < num_aircrafts; i++) {
        printf("\nAircraft %d starting bag handling:\n", aircrafts[i].id);
        print_bags(aircrafts[i].bags, aircrafts[i].num_bags);
        free(aircrafts[i].bags);
    }
}