//LLAMA2-13B DATASET v1.0 Category: Password management ; Style: protected
#include <stdio.h>
#include <string.h>
#include <stdbool.h>

#define MAX_PASSWORDS 10
#define MAX_ATTEMPTS 3

typedef struct {
    char *password;
    int attempts;
} password_struct;

password_struct passwords[MAX_PASSWORDS];
int current_password = 0;

void init_passwords() {
    int i;
    for (i = 0; i < MAX_PASSWORDS; i++) {
        passwords[i].password = NULL;
        passwords[i].attempts = 0;
    }
}

void add_password(const char *password) {
    int i;
    for (i = 0; i < MAX_PASSWORDS; i++) {
        if (passwords[i].password == NULL) {
            passwords[i].password = strdup(password);
            passwords[i].attempts = 0;
            break;
        }
    }
}

void login(const char *username, const char *password) {
    int i;
    for (i = 0; i < MAX_PASSWORDS; i++) {
        if (strcmp(passwords[i].password, password) == 0) {
            passwords[i].attempts++;
            if (passwords[i].attempts >= MAX_ATTEMPTS) {
                passwords[i].password = NULL;
            }
            break;
        }
    }
}

void logout(const char *username) {
    int i;
    for (i = 0; i < MAX_PASSWORDS; i++) {
        if (strcmp(passwords[i].password, username) == 0) {
            passwords[i].password = NULL;
            passwords[i].attempts = 0;
        }
    }
}

int main() {
    init_passwords();

    // Example usage
    add_password("password1");
    add_password("password2");
    add_password("password3");

    login("user1", "password1");
    login("user2", "password2");
    login("user3", "password3");

    logout("user1");
    logout("user2");
    logout("user3");

    return 0;
}