//GEMINI-pro DATASET v1.0 Category: Image to ASCII art converter ; Style: intelligent
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// Define the maximum image size
#define MAX_WIDTH 1024
#define MAX_HEIGHT 1024

// Define the ASCII characters used for the image
char *ASCII_CHARS = " .:-=+*#%@"
                       "░▒▒▓▓███";

// Convert an image to ASCII art
int main(int argc, char *argv[]) {
  // Check if the user has provided an image file
  if (argc != 2) {
    printf("Usage: %s <image_file>\n", argv[0]);
    return 1;
  }

  // Open the image file
  FILE *image_file = fopen(argv[1], "rb");
  if (image_file == NULL) {
    printf("Error opening image file: %s\n", argv[1]);
    return 1;
  }

  // Get the image width and height
  int width, height;
  fscanf(image_file, "%d %d", &width, &height);

  // Check if the image is too large
  if (width > MAX_WIDTH || height > MAX_HEIGHT) {
    printf("Error: Image is too large (max size: %dx%d)\n", MAX_WIDTH, MAX_HEIGHT);
    return 1;
  }

  // Read the image data into a buffer
  unsigned char *image_data = malloc(width * height * 3);
  fread(image_data, 1, width * height * 3, image_file);

  // Close the image file
  fclose(image_file);

  // Convert the image data to ASCII art
  char *ascii_art = malloc(width * height + 1);
  for (int y = 0; y < height; y++) {
    for (int x = 0; x < width; x++) {
      // Get the RGB values of the pixel
      int r = image_data[3 * (y * width + x) + 0];
      int g = image_data[3 * (y * width + x) + 1];
      int b = image_data[3 * (y * width + x) + 2];

      // Calculate the grayscale value of the pixel
      int grayscale = (r + g + b) / 3;

      // Convert the grayscale value to an ASCII character
      int index = (int) ((grayscale / 255.0) * (strlen(ASCII_CHARS) - 1));
      ascii_art[y * width + x] = ASCII_CHARS[index];
    }
  }

  // Add a newline character to the end of the ASCII art
  ascii_art[width * height] = '\0';

  // Print the ASCII art
  printf("%s\n", ascii_art);

  // Free the memory allocated for the image data and the ASCII art
  free(image_data);
  free(ascii_art);

  return 0;
}