//GEMINI-pro DATASET v1.0 Category: Phone Book ; Style: systematic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

struct phonebook_entry {
    char *name;
    char *number;
};

struct phonebook {
    int num_entries;
    struct phonebook_entry *entries;
};

struct phonebook *create_phonebook(void) {
    struct phonebook *phonebook = malloc(sizeof(struct phonebook));
    if (phonebook == NULL) {
        return NULL;
    }

    phonebook->num_entries = 0;
    phonebook->entries = NULL;

    return phonebook;
}

void free_phonebook(struct phonebook *phonebook) {
    if (phonebook == NULL) {
        return;
    }

    for (int i = 0; i < phonebook->num_entries; i++) {
        free(phonebook->entries[i].name);
        free(phonebook->entries[i].number);
    }

    free(phonebook->entries);
    free(phonebook);
}

int add_entry_to_phonebook(struct phonebook *phonebook, char *name, char *number) {
    if (phonebook == NULL || name == NULL || number == NULL) {
        return -1;
    }

    struct phonebook_entry *new_entry = malloc(sizeof(struct phonebook_entry));
    if (new_entry == NULL) {
        return -1;
    }

    new_entry->name = strdup(name);
    if (new_entry->name == NULL) {
        free(new_entry);
        return -1;
    }

    new_entry->number = strdup(number);
    if (new_entry->number == NULL) {
        free(new_entry->name);
        free(new_entry);
        return -1;
    }

    phonebook->entries = realloc(phonebook->entries, (phonebook->num_entries + 1) * sizeof(struct phonebook_entry));
    if (phonebook->entries == NULL) {
        free(new_entry->name);
        free(new_entry->number);
        free(new_entry);
        return -1;
    }

    phonebook->entries[phonebook->num_entries] = *new_entry;
    phonebook->num_entries++;

    return 0;
}

int find_entry_in_phonebook(struct phonebook *phonebook, char *name) {
    if (phonebook == NULL || name == NULL) {
        return -1;
    }

    for (int i = 0; i < phonebook->num_entries; i++) {
        if (strcmp(phonebook->entries[i].name, name) == 0) {
            return i;
        }
    }

    return -1;
}

int remove_entry_from_phonebook(struct phonebook *phonebook, char *name) {
    if (phonebook == NULL || name == NULL) {
        return -1;
    }

    int index = find_entry_in_phonebook(phonebook, name);
    if (index == -1) {
        return -1;
    }

    free(phonebook->entries[index].name);
    free(phonebook->entries[index].number);

    for (int i = index + 1; i < phonebook->num_entries; i++) {
        phonebook->entries[i - 1] = phonebook->entries[i];
    }

    phonebook->num_entries--;

    return 0;
}

int main(void) {
    struct phonebook *phonebook = create_phonebook();

    if (phonebook == NULL) {
        printf("Error: Could not create phonebook.\n");
        return EXIT_FAILURE;
    }

    int result = add_entry_to_phonebook(phonebook, "John Doe", "555-1212");

    if (result == -1) {
        printf("Error: Could not add entry to phonebook.\n");
        free_phonebook(phonebook);
        return EXIT_FAILURE;
    }

    result = add_entry_to_phonebook(phonebook, "Jane Doe", "555-1213");

    if (result == -1) {
        printf("Error: Could not add entry to phonebook.\n");
        free_phonebook(phonebook);
        return EXIT_FAILURE;
    }

    int index = find_entry_in_phonebook(phonebook, "John Doe");

    if (index == -1) {
        printf("Error: Could not find entry in phonebook.\n");
        free_phonebook(phonebook);
        return EXIT_FAILURE;
    }

    printf("Found entry for '%s' with number '%s'.\n", phonebook->entries[index].name, phonebook->entries[index].number);

    result = remove_entry_from_phonebook(phonebook, "John Doe");

    if (result == -1) {
        printf("Error: Could not remove entry from phonebook.\n");
        free_phonebook(phonebook);
        return EXIT_FAILURE;
    }

    free_phonebook(phonebook);

    return EXIT_SUCCESS;
}