//GEMINI-pro DATASET v1.0 Category: Resume Parsing System ; Style: careful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum number of resumes to be parsed
#define MAX_RESUMES 100

// Define the maximum length of a resume
#define MAX_RESUME_LENGTH 10000

// Define the maximum number of skills to be extracted from a resume
#define MAX_SKILLS 100

// Define the maximum length of a skill
#define MAX_SKILL_LENGTH 100

// Define the data structure for a resume
typedef struct resume {
    char *name;
    char *email;
    char *phone;
    char *address;
    char *skills[MAX_SKILLS];
    int num_skills;
} resume;

// Define the data structure for the resume parsing system
typedef struct resume_parsing_system {
    resume resumes[MAX_RESUMES];
    int num_resumes;
} resume_parsing_system;

// Create a new resume parsing system
resume_parsing_system *create_resume_parsing_system() {
    resume_parsing_system *system = malloc(sizeof(resume_parsing_system));
    system->num_resumes = 0;
    return system;
}

// Destroy a resume parsing system
void destroy_resume_parsing_system(resume_parsing_system *system) {
    for (int i = 0; i < system->num_resumes; i++) {
        free(system->resumes[i].name);
        free(system->resumes[i].email);
        free(system->resumes[i].phone);
        free(system->resumes[i].address);
        for (int j = 0; j < system->resumes[i].num_skills; j++) {
            free(system->resumes[i].skills[j]);
        }
    }
    free(system);
}

// Add a resume to the resume parsing system
void add_resume(resume_parsing_system *system, resume *resume) {
    if (system->num_resumes < MAX_RESUMES) {
        system->resumes[system->num_resumes++] = *resume;
    }
}

// Parse a resume and extract the name, email, phone, address, and skills
resume *parse_resume(char *resume_text) {
    resume *resume = malloc(sizeof(resume));

    // Extract the name
    char *name = strtok(resume_text, "\n");
    resume->name = malloc(strlen(name) + 1);
    strcpy(resume->name, name);

    // Extract the email
    char *email = strtok(NULL, "\n");
    resume->email = malloc(strlen(email) + 1);
    strcpy(resume->email, email);

    // Extract the phone
    char *phone = strtok(NULL, "\n");
    resume->phone = malloc(strlen(phone) + 1);
    strcpy(resume->phone, phone);

    // Extract the address
    char *address = strtok(NULL, "\n");
    resume->address = malloc(strlen(address) + 1);
    strcpy(resume->address, address);

    // Extract the skills
    resume->num_skills = 0;
    char *skill = strtok(NULL, "\n");
    while (skill != NULL) {
        resume->skills[resume->num_skills++] = malloc(strlen(skill) + 1);
        strcpy(resume->skills[resume->num_skills - 1], skill);
        skill = strtok(NULL, "\n");
    }

    return resume;
}

// Print a resume
void print_resume(resume *resume) {
    printf("Name: %s\n", resume->name);
    printf("Email: %s\n", resume->email);
    printf("Phone: %s\n", resume->phone);
    printf("Address: %s\n", resume->address);
    printf("Skills:\n");
    for (int i = 0; i < resume->num_skills; i++) {
        printf("  - %s\n", resume->skills[i]);
    }
}

// Main function
int main() {
    // Create a resume parsing system
    resume_parsing_system *system = create_resume_parsing_system();

    // Parse a resume from a file
    FILE *file = fopen("resume.txt", "r");
    char *resume_text = malloc(MAX_RESUME_LENGTH);
    fread(resume_text, MAX_RESUME_LENGTH, 1, file);
    fclose(file);

    // Parse the resume
    resume *resume = parse_resume(resume_text);

    // Add the resume to the resume parsing system
    add_resume(system, resume);

    // Print the resume
    print_resume(resume);

    // Destroy the resume parsing system
    destroy_resume_parsing_system(system);

    return 0;
}