//Gemma-7B DATASET v1.0 Category: Graph representation ; Style: mathematical
#include <stdio.h>
#include <stdlib.h>

#define MAX 10

typedef struct Node {
    int data;
    struct Node* next;
} Node;

struct Graph {
    Node** adjacencyList;
    int numVertices;
};

void insertNode(struct Graph* graph, int data) {
    Node* newNode = (Node*)malloc(sizeof(Node));
    newNode->data = data;
    newNode->next = NULL;

    if (graph->adjacencyList == NULL) {
        graph->adjacencyList = (Node**)malloc(sizeof(Node*) * MAX);
        graph->numVertices = 0;
    }

    graph->adjacencyList[graph->numVertices++] = newNode;
}

void traverseGraph(struct Graph* graph) {
    for (int i = 0; i < graph->numVertices; i++) {
        Node* current = graph->adjacencyList[i];
        while (current) {
            printf("%d ", current->data);
            current = current->next;
        }
        printf("\n");
    }
}

int main() {
    struct Graph* graph = (struct Graph*)malloc(sizeof(struct Graph));
    graph->adjacencyList = NULL;
    graph->numVertices = 0;

    insertNode(graph, 1);
    insertNode(graph, 2);
    insertNode(graph, 3);
    insertNode(graph, 4);
    insertNode(graph, 5);

    traverseGraph(graph);

    return 0;
}