//GEMINI-pro DATASET v1.0 Category: Data structures visualization ; Style: standalone
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the node structure
typedef struct node {
    int data;
    struct node *next;
} node_t;

// Define the linked list structure
typedef struct linked_list {
    node_t *head;
    node_t *tail;
    int size;
} linked_list_t;

// Create a new linked list
linked_list_t *create_linked_list() {
    linked_list_t *list = malloc(sizeof(linked_list_t));
    list->head = NULL;
    list->tail = NULL;
    list->size = 0;
    return list;
}

// Insert a node at the beginning of the linked list
void insert_at_beginning(linked_list_t *list, int data) {
    node_t *new_node = malloc(sizeof(node_t));
    new_node->data = data;
    new_node->next = list->head;
    list->head = new_node;
    if (list->tail == NULL) {
        list->tail = new_node;
    }
    list->size++;
}

// Insert a node at the end of the linked list
void insert_at_end(linked_list_t *list, int data) {
    node_t *new_node = malloc(sizeof(node_t));
    new_node->data = data;
    new_node->next = NULL;
    if (list->tail == NULL) {
        list->head = new_node;
        list->tail = new_node;
    } else {
        list->tail->next = new_node;
        list->tail = new_node;
    }
    list->size++;
}

// Insert a node at a specific index in the linked list
void insert_at_index(linked_list_t *list, int index, int data) {
    if (index < 0 || index > list->size) {
        return;
    }
    if (index == 0) {
        insert_at_beginning(list, data);
    } else if (index == list->size) {
        insert_at_end(list, data);
    } else {
        node_t *new_node = malloc(sizeof(node_t));
        new_node->data = data;
        node_t *current_node = list->head;
        for (int i = 0; i < index - 1; i++) {
            current_node = current_node->next;
        }
        new_node->next = current_node->next;
        current_node->next = new_node;
        list->size++;
    }
}

// Delete a node from the beginning of the linked list
void delete_from_beginning(linked_list_t *list) {
    if (list->head == NULL) {
        return;
    }
    node_t *current_node = list->head;
    list->head = current_node->next;
    free(current_node);
    list->size--;
    if (list->head == NULL) {
        list->tail = NULL;
    }
}

// Delete a node from the end of the linked list
void delete_from_end(linked_list_t *list) {
    if (list->tail == NULL) {
        return;
    }
    node_t *current_node = list->head;
    if (current_node->next == NULL) {
        list->head = NULL;
        list->tail = NULL;
    } else {
        while (current_node->next != list->tail) {
            current_node = current_node->next;
        }
        current_node->next = NULL;
        list->tail = current_node;
    }
    list->size--;
}

// Delete a node at a specific index in the linked list
void delete_at_index(linked_list_t *list, int index) {
    if (index < 0 || index >= list->size) {
        return;
    }
    if (index == 0) {
        delete_from_beginning(list);
    } else if (index == list->size - 1) {
        delete_from_end(list);
    } else {
        node_t *current_node = list->head;
        for (int i = 0; i < index - 1; i++) {
            current_node = current_node->next;
        }
        node_t *node_to_delete = current_node->next;
        current_node->next = node_to_delete->next;
        free(node_to_delete);
        list->size--;
    }
}

// Print the linked list
void print_linked_list(linked_list_t *list) {
    node_t *current_node = list->head;
    while (current_node != NULL) {
        printf("%d ", current_node->data);
        current_node = current_node->next;
    }
    printf("\n");
}

// Free the linked list
void free_linked_list(linked_list_t *list) {
    node_t *current_node = list->head;
    while (current_node != NULL) {
        node_t *next_node = current_node->next;
        free(current_node);
        current_node = next_node;
    }
    free(list);
}

// Main function
int main() {
    // Create a linked list
    linked_list_t *list = create_linked_list();

    // Insert some nodes into the linked list
    insert_at_beginning(list, 1);
    insert_at_end(list, 2);
    insert_at_index(list, 1, 3);

    // Print the linked list
    print_linked_list(list);

    // Delete a node from the beginning of the linked list
    delete_from_beginning(list);

    // Delete a node from the end of the linked list
    delete_from_end(list);

    // Delete a node at a specific index in the linked list
    delete_at_index(list, 1);

    // Print the linked list
    print_linked_list(list);

    // Free the linked list
    free_linked_list(list);

    return 0;
}