//GEMINI-pro DATASET v1.0 Category: QR code generator ; Style: lively
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>

#define MAX_SIZE 100

typedef struct {
    int size;
    char **data;
} QRCode;

QRCode *create_qrcode(char *text) {
    int text_len = strlen(text);
    int size = (text_len + 7) / 8;
    if (size > MAX_SIZE) {
        return NULL;
    }
    QRCode *qrcode = malloc(sizeof(QRCode));
    qrcode->size = size;
    qrcode->data = malloc(sizeof(char *) * size);
    for (int i = 0; i < size; i++) {
        qrcode->data[i] = malloc(sizeof(char) * size);
        for (int j = 0; j < size; j++) {
            qrcode->data[i][j] = ' ';
        }
    }
    int index = 0;
    for (int i = 0; i < size; i++) {
        for (int j = 0; j < size; j++) {
            if (index < text_len) {
                qrcode->data[i][j] = text[index];
                index++;
            }
        }
    }
    return qrcode;
}

void print_qrcode(QRCode *qrcode) {
    for (int i = 0; i < qrcode->size; i++) {
        for (int j = 0; j < qrcode->size; j++) {
            printf("%c", qrcode->data[i][j]);
        }
        printf("\n");
    }
}

void free_qrcode(QRCode *qrcode) {
    for (int i = 0; i < qrcode->size; i++) {
        free(qrcode->data[i]);
    }
    free(qrcode->data);
    free(qrcode);
}

int main() {
    char *text = "Hello, world!";
    QRCode *qrcode = create_qrcode(text);
    if (qrcode == NULL) {
        printf("Error: QR code is too large.\n");
    } else {
        printf("QR code:\n");
        print_qrcode(qrcode);
        free_qrcode(qrcode);
    }
    return 0;
}