//MISTRAL-7B DATASET v1.0 Category: Ebook reader ; Style: random
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>

#define MAX_BOOK_SIZE 1048576
#define BUFFER_SIZE 4096

typedef struct book {
    char title[256];
    char author[256];
    char *content;
    size_t size;
} book;

void error_exit(const char *msg) {
    perror(msg);
    exit(EXIT_FAILURE);
}

book *load_book(const char *filename) {
    int fd;
    size_t title_size, author_size, content_size;
    char title[256], author[256];
    book *book;

    fd = open(filename, O_RDONLY);
    if (fd == -1) error_exit("open");

    title_size = read(fd, title, sizeof(title) - 1);
    if (title_size > sizeof(title) - 1 || title_size == 0) {
        close(fd);
        error_exit("title read error");
    }
    title[title_size] = '\0';

    author_size = read(fd, author, sizeof(author) - 1);
    if (author_size > sizeof(author) - 1 || author_size == 0) {
        close(fd);
        error_exit("author read error");
    }
    author[author_size] = '\0';

    fseek(fd, -(sizeof(title) + sizeof(author)), SEEK_CUR);

    content_size = lseek(fd, 0, SEEK_END) - (sizeof(title) + sizeof(author));
    if (content_size > MAX_BOOK_SIZE) {
        close(fd);
        error_exit("book size too big");
    }

    book = malloc(sizeof(book) + content_size);
    if (!book) {
        close(fd);
        error_exit("malloc");
    }

    strncpy(book->title, title, sizeof(book->title) - 1);
    strncpy(book->author, author, sizeof(book->author) - 1);
    book->size = content_size;

    read(fd, book->content, content_size);
    close(fd);

    return book;
}

void print_book(const book *book) {
    printf("Title: %s\n", book->title);
    printf("Author: %s\n", book->author);
    printf("Size: %zu bytes\n", book->size);
    printf("Content:\n");

    for (const char *c = book->content; c < book->content + book->size; c++) {
        putchar(*c);
    }

    putchar('\n');
}

void free_book(book *book) {
    free(book->content);
    free(book);
}

int main(int argc, char **argv) {
    if (argc != 2) {
        fprintf(stderr, "Usage: %s <bookfile>\n", argv[0]);
        return EXIT_FAILURE;
    }

    book *book = load_book(argv[1]);
    print_book(book);
    free_book(book);

    return EXIT_SUCCESS;
}