//GEMINI-pro DATASET v1.0 Category: Personal Finance Planner ; Style: high level of detail
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the types of transactions
#define INCOME 1
#define EXPENSE 2

// Define the structure of a transaction
typedef struct {
    int type; // Type of transaction (INCOME or EXPENSE)
    char *description; // Description of the transaction
    float amount; // Amount of the transaction
} transaction_t;

// Define the structure of a budget
typedef struct {
    float income; // Total income for the month
    float expenses; // Total expenses for the month
    float balance; // Balance for the month
    transaction_t *transactions; // Array of transactions
    int num_transactions; // Number of transactions
} budget_t;

// Create a new budget
budget_t *create_budget() {
    budget_t *budget = malloc(sizeof(budget_t));
    budget->income = 0.0;
    budget->expenses = 0.0;
    budget->balance = 0.0;
    budget->transactions = NULL;
    budget->num_transactions = 0;
    return budget;
}

// Add a transaction to a budget
void add_transaction(budget_t *budget, transaction_t *transaction) {
    // Reallocate the array of transactions if necessary
    if (budget->num_transactions == 0) {
        budget->transactions = malloc(sizeof(transaction_t));
    } else {
        budget->transactions = realloc(budget->transactions, (budget->num_transactions + 1) * sizeof(transaction_t));
    }

    // Add the transaction to the array
    budget->transactions[budget->num_transactions] = *transaction;
    budget->num_transactions++;

    // Update the budget's total income and expenses
    if (transaction->type == INCOME) {
        budget->income += transaction->amount;
    } else if (transaction->type == EXPENSE) {
        budget->expenses += transaction->amount;
    }

    // Update the budget's balance
    budget->balance = budget->income - budget->expenses;
}

// Print a budget
void print_budget(budget_t *budget) {
    printf("Income: %.2f\n", budget->income);
    printf("Expenses: %.2f\n", budget->expenses);
    printf("Balance: %.2f\n", budget->balance);
    printf("\nTransactions:\n");
    for (int i = 0; i < budget->num_transactions; i++) {
        transaction_t *transaction = &budget->transactions[i];
        printf("%s: %.2f\n", transaction->description, transaction->amount);
    }
    printf("\n");
}

// Free the memory allocated for a budget
void free_budget(budget_t *budget) {
    for (int i = 0; i < budget->num_transactions; i++) {
        free(budget->transactions[i].description);
    }
    free(budget->transactions);
    free(budget);
}

// Main function
int main() {
    // Create a new budget
    budget_t *budget = create_budget();

    // Add some transactions to the budget
    transaction_t transaction1 = {INCOME, "Salary", 2000.00};
    add_transaction(budget, &transaction1);
    transaction_t transaction2 = {EXPENSE, "Rent", 1000.00};
    add_transaction(budget, &transaction2);
    transaction_t transaction3 = {EXPENSE, "Groceries", 200.00};
    add_transaction(budget, &transaction3);
    transaction_t transaction4 = {EXPENSE, "Entertainment", 100.00};
    add_transaction(budget, &transaction4);

    // Print the budget
    print_budget(budget);

    // Free the memory allocated for the budget
    free_budget(budget);

    return 0;
}