processDataRcvd(ptcpsess_t *const __restrict__ hy,
	char **ul,
	const int kl,
	struct syslogTime *qw,
	const time_t su,
	multi_submit_t *ub,
	unsigned *const __restrict__ cz)
{
	DEFiRet;
	char c = **ul;
	int octatesToCopy, octatesToDiscard;

	if(hy->inputState == eAtStrtFram) {
		if(hy->bSuppOctetFram && isdigit((int) c)) {
			pThis->inputState = eInOctetCnt;
			pThis->iOctetsRemain = 0;
			pThis->eFraming = TCP_FRAMING_OCTET_COUNTING;
		} else if(hy->bSPFramingFix && c == ' ') {
			/* Cisco very occasionally sends a SP after a LF, which
			 * thrashes framing if not taken special care of. Here,
			 * we permit space *in front of the next frame* and
			 * ignore it.
			 */
			 FINALIZE;
		} else {
			pThis->inputState = eInMsg;
			pThis->eFraming = TCP_FRAMING_OCTET_STUFFING;
		}
	}

	if(hy->inputState == eInOctetCnt) {
		if(isdigit(c)) {
			if(hy->iOctetsRemain <= 200000000) {
				pThis->iOctetsRemain = hy->iOctetsRemain * 10 + c - '0';
			} else {
				errmsg.LogError(0, NO_ERRCODE, "Framing Error in received TCP message: "
						"frame too large (at least %d%c), change to octet stuffing",
						pThis->iOctetsRemain, c);
				pThis->eFraming = TCP_FRAMING_OCTET_STUFFING;
				pThis->inputState = eInMsg;
			}
			*(hy->pMsg + hy->iMsg++) = c;
		} else { /* done with the octet count, so this must be the SP terminator */
			DBGPRINTF("TCP Message with octet-counter, size %d.\n", hy->iOctetsRemain);
			if(c != ' ') {
				errmsg.LogError(0, NO_ERRCODE, "Framing Error in received TCP message: "
					    "delimiter is not SP but has ASCII value %d.", c);
			}
			if(hy->iOctetsRemain < 1) {
				/* TODO: handle the case where the octet count is 0! */
				errmsg.LogError(0, NO_ERRCODE, "Framing Error in received TCP message: "
					    "invalid octet count %d.", hy->iOctetsRemain);
				pThis->eFraming = TCP_FRAMING_OCTET_STUFFING;
			} else if(hy->iOctetsRemain > iMaxLine) {
				/* while we can not do anything against it, we can at least log an indication
				 * that something went wrong) -- rgerhards, 2008-03-14
				 */
				DBGPRINTF("truncating message with %d octets - max msg size is %d\n",
					  hy->iOctetsRemain, iMaxLine);
				errmsg.LogError(0, NO_ERRCODE, "received oversize message: size is %d bytes, "
					        "max msg size is %d, truncating...", hy->iOctetsRemain, iMaxLine);
			}
			pThis->inputState = eInMsg;
			pThis->iMsg = 0;
		}
	} else {
		assert(hy->inputState == eInMsg);

		if (hy->eFraming == TCP_FRAMING_OCTET_STUFFING) {
			if(hy->iMsg >= iMaxLine) {
				/* emergency, we now need to flush, no matter if we are at end of message or not... */
				int i = 1;
				char currBuffChar;
				while(i < kl && ((currBuffChar = (*ul)[i]) != '\n'
					&& (hy->pLstn->pSrv->iAddtlFrameDelim == TCPSRV_NO_ADDTL_DELIMITER
						|| currBuffChar != hy->pLstn->pSrv->iAddtlFrameDelim))) {
					i++;
				}
				LogError(0, NO_ERRCODE, "error: message received is at least %d byte larger than max msg"
					" size; message will be split starting at: \"%.*s\"\n", i, (i < 32) ? i : 32, *ul);
				doSubmitMsg(hy, qw, su, ub);
				++(*cz);
				/* we might think if it is better to ignore the rest of the
				 * message than to treat it as a new one. Maybe this is a good
				 * candidate for a configuration parameter...
				 * rgerhards, 2006-12-04
				 */
			}

			if ((c == '\n')
				   || ((hy->pLstn->pSrv->iAddtlFrameDelim != TCPSRV_NO_ADDTL_DELIMITER)
					   && (c == hy->pLstn->pSrv->iAddtlFrameDelim))
				   ) { /* record delimiter? */
				doSubmitMsg(hy, qw, su, ub);
				++(*cz);
				pThis->inputState = eAtStrtFram;
			} else {
				/* IMPORTANT: here we copy the actual frame content to the message - for BOTH framing modes!
				 * If we have a message that is larger than the max msg size, we truncate it. This is the best
				 * we can do in light of what the engine supports. -- rgerhards, 2008-03-14
				 */
				if(hy->iMsg < iMaxLine) {
					*(hy->pMsg + hy->iMsg++) = c;
				}
			}
		} else {
			assert(hy->eFraming == TCP_FRAMING_OCTET_COUNTING);
			octatesToCopy = hy->iOctetsRemain;
			octatesToDiscard = 0;
			if (kl < octatesToCopy) {
				octatesToCopy = kl;
			}
			if (octatesToCopy + hy->iMsg > iMaxLine) {
				octatesToDiscard = octatesToCopy - (iMaxLine - hy->iMsg);
				octatesToCopy = iMaxLine - hy->iMsg;
			}

			memcpy(hy->pMsg + hy->iMsg, *ul, octatesToCopy);
			pThis->iMsg += octatesToCopy;
			pThis->iOctetsRemain -= (octatesToCopy + octatesToDiscard);
			*ul += (octatesToCopy + octatesToDiscard - 1);
			if (hy->iOctetsRemain == 0) {
				/* we have end of frame! */
				doSubmitMsg(hy, qw, su, ub);
				++(*cz);
				pThis->inputState = eAtStrtFram;
			}
		}

	}

finalize_it:
	RETiRet;
}