//Falcon-180B DATASET v1.0 Category: Sorting ; Style: realistic
#include <stdio.h>
#include <stdlib.h>

// Define a struct for a person
typedef struct {
    char name[50];
    int age;
    float height;
} Person;

// Define a function to compare two people by age
int compare_age(const void* a, const void* b) {
    const Person* person_a = (const Person*)a;
    const Person* person_b = (const Person*)b;

    if (person_a->age < person_b->age) {
        return -1;
    } else if (person_a->age > person_b->age) {
        return 1;
    } else {
        return 0;
    }
}

// Define a function to compare two people by height
int compare_height(const void* a, const void* b) {
    const Person* person_a = (const Person*)a;
    const Person* person_b = (const Person*)b;

    if (person_a->height < person_b->height) {
        return -1;
    } else if (person_a->height > person_b->height) {
        return 1;
    } else {
        return 0;
    }
}

// Define a function to print a person's information
void print_person(const void* ptr) {
    const Person* person = (const Person*)ptr;

    printf("Name: %s\n", person->name);
    printf("Age: %d\n", person->age);
    printf("Height: %.2f\n\n", person->height);
}

int main() {
    // Initialize an array of people
    Person people[] = {
        {"Alice", 25, 165.5},
        {"Bob", 30, 180.0},
        {"Charlie", 20, 170.2},
        {"David", 28, 175.8},
        {"Eve", 22, 168.1}
    };

    // Sort the array by age
    qsort(people, sizeof(people) / sizeof(Person), sizeof(Person), compare_age);

    // Print the sorted array
    printf("Sorted by age:\n");
    for (int i = 0; i < sizeof(people) / sizeof(Person); i++) {
        print_person(&people[i]);
    }

    // Sort the array by height
    qsort(people, sizeof(people) / sizeof(Person), sizeof(Person), compare_height);

    // Print the sorted array
    printf("\nSorted by height:\n");
    for (int i = 0; i < sizeof(people) / sizeof(Person); i++) {
        print_person(&people[i]);
    }

    return 0;
}