//GEMINI-pro DATASET v1.0 Category: Movie Rating System ; Style: Dennis Ritchie
#include <stdio.h>
#include <stdlib.h>

// Dennis Ritchie style C code to implement a movie rating system

// Define the movie rating system
typedef enum {
    G, // General audiences
    PG, // Parental guidance suggested
    PG13, // Parents strongly cautioned
    R, // Restricted
    NC17 // No one 17 and under admitted
} rating;

// Define the movie structure
typedef struct {
    char *title;
    rating rating;
    int year;
} movie;

// Create a function to print the movie rating
void print_rating(rating rating) {
    switch (rating) {
        case G:
            printf("G");
            break;
        case PG:
            printf("PG");
            break;
        case PG13:
            printf("PG-13");
            break;
        case R:
            printf("R");
            break;
        case NC17:
            printf("NC-17");
            break;
    }
}

// Create a function to compare two movies by rating
int compare_movies(const void *a, const void *b) {
    const movie *movie1 = (const movie *)a;
    const movie *movie2 = (const movie *)b;

    return movie1->rating - movie2->rating;
}

// Create a function to print a list of movies
void print_movies(movie *movies, int num_movies) {
    for (int i = 0; i < num_movies; i++) {
        printf("%s (%d) ", movies[i].title, movies[i].year);
        print_rating(movies[i].rating);
        printf("\n");
    }
}

// Main function
int main() {
    // Create an array of movies
    movie movies[] = {
        {"The Shawshank Redemption", PG13, 1994},
        {"The Godfather", R, 1972},
        {"The Dark Knight", PG13, 2008},
        {"12 Angry Men", PG, 1957},
        {"Schindler's List", R, 1993},
        {"The Lord of the Rings: The Return of the King", PG13, 2003},
        {"Pulp Fiction", R, 1994},
        {"The Matrix", R, 1999},
        {"Fight Club", R, 1999},
        {"The Silence of the Lambs", R, 1991}
    };

    // Sort the movies by rating
    qsort(movies, sizeof(movies) / sizeof(movie), sizeof(movie), compare_movies);

    // Print the list of movies
    print_movies(movies, sizeof(movies) / sizeof(movie));

    return 0;
}