//Falcon-180B DATASET v1.0 Category: Smart home light control ; Style: modular
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

#define NUM_LIGHTS 4

typedef struct {
    char name[20];
    bool is_on;
} Light;

Light lights[NUM_LIGHTS];

void init_lights() {
    for (int i = 0; i < NUM_LIGHTS; i++) {
        lights[i].is_on = false;
    }
}

void turn_on_light(int light_index) {
    if (light_index >= 0 && light_index < NUM_LIGHTS) {
        lights[light_index].is_on = true;
        printf("Turned on light %s\n", lights[light_index].name);
    } else {
        printf("Invalid light index\n");
    }
}

void turn_off_light(int light_index) {
    if (light_index >= 0 && light_index < NUM_LIGHTS) {
        lights[light_index].is_on = false;
        printf("Turned off light %s\n", lights[light_index].name);
    } else {
        printf("Invalid light index\n");
    }
}

void toggle_light(int light_index) {
    if (light_index >= 0 && light_index < NUM_LIGHTS) {
        lights[light_index].is_on =!lights[light_index].is_on;
        if (lights[light_index].is_on) {
            printf("Turned on light %s\n", lights[light_index].name);
        } else {
            printf("Turned off light %s\n", lights[light_index].name);
        }
    } else {
        printf("Invalid light index\n");
    }
}

void print_light_status() {
    for (int i = 0; i < NUM_LIGHTS; i++) {
        printf("Light %d: %s\n", i+1, lights[i].name);
        if (lights[i].is_on) {
            printf("\tOn\n");
        } else {
            printf("\tOff\n");
        }
    }
}

int main() {
    init_lights();
    turn_on_light(0);
    turn_off_light(1);
    toggle_light(2);
    print_light_status();
    return 0;
}