//MISTRAL-7B DATASET v1.0 Category: Hotel Management System ; Style: protected
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>

#define MAX_ROOMS 100
#define MAX_NAME_LENGTH 50
#define MAX_PHONE_LENGTH 20

typedef struct {
    char name[MAX_NAME_LENGTH];
    char phone[MAX_PHONE_LENGTH];
    bool occupied;
} Room;

Room rooms[MAX_ROOMS];

void initialize_rooms() {
    for (int i = 0; i < MAX_ROOMS; i++) {
        strcpy(rooms[i].name, "");
        strcpy(rooms[i].phone, "");
        rooms[i].occupied = false;
    }
}

int find_available_room() {
    for (int i = 0; i < MAX_ROOMS; i++) {
        if (!rooms[i].occupied) {
            return i;
        }
    }
    return -1;
}

void check_in(const char *name, const char *phone) {
    int room_number = find_available_room();
    if (room_number == -1) {
        printf("No available room.\n");
        return;
    }
    strcpy(rooms[room_number].name, name);
    strcpy(rooms[room_number].phone, phone);
    rooms[room_number].occupied = true;
    printf("Checked in successfully. Your room number is %d.\n", room_number);
}

void check_out(int room_number) {
    if (rooms[room_number].occupied) {
        rooms[room_number].occupied = false;
        strcpy(rooms[room_number].name, "");
        strcpy(rooms[room_number].phone, "");
        printf("Checked out successfully.\n");
    } else {
        printf("Room %d is already vacant.\n", room_number);
    }
}

int main() {
    initialize_rooms();
    int choice;
    while (true) {
        printf("\nHotel Management System\n");
        printf("1. Check in\n");
        printf("2. Check out\n");
        printf("3. Exit\n");
        printf("Enter your choice: ");
        scanf("%d", &choice);
        switch (choice) {
            case 1: {
                char name[MAX_NAME_LENGTH];
                char phone[MAX_PHONE_LENGTH];
                printf("Enter your name: ");
                scanf("%s", name);
                printf("Enter your phone number: ");
                scanf("%s", phone);
                check_in(name, phone);
                break;
            }
            case 2: {
                int room_number;
                printf("Enter your room number: ");
                scanf("%d", &room_number);
                check_out(room_number);
                break;
            }
            case 3:
                exit(0);
            default:
                printf("Invalid choice.\n");
        }
    }
    return 0;
}