//Falcon-180B DATASET v1.0 Category: Smart home light control ; Style: lively
#include <stdio.h>
#include <stdlib.h>

#define TRUE 1
#define FALSE 0
#define MAX_LIGHTS 10

// Data structure to represent a light
typedef struct {
    char name[20];
    int state;
} Light;

// Function to turn a light on
void turnOnLight(Light* light) {
    printf("Turning on %s...\n", light->name);
    light->state = TRUE;
}

// Function to turn a light off
void turnOffLight(Light* light) {
    printf("Turning off %s...\n", light->name);
    light->state = FALSE;
}

// Function to toggle a light
void toggleLight(Light* light) {
    if (light->state == TRUE) {
        turnOffLight(light);
    } else {
        turnOnLight(light);
    }
}

// Function to initialize a light
void initLight(Light* light, char* name) {
    strcpy(light->name, name);
    light->state = FALSE;
}

// Main function
int main() {
    // Initialize lights
    Light lights[MAX_LIGHTS];
    initLight(&lights[0], "Living Room");
    initLight(&lights[1], "Kitchen");
    initLight(&lights[2], "Bedroom");
    initLight(&lights[3], "Bathroom");

    // Turn on lights
    turnOnLight(&lights[0]);
    turnOnLight(&lights[1]);

    // Toggle lights
    toggleLight(&lights[0]);
    toggleLight(&lights[2]);

    // Turn off lights
    turnOffLight(&lights[1]);
    turnOffLight(&lights[3]);

    return 0;
}