//MISTRAL-7B DATASET v1.0 Category: Building a HTTP Client ; Style: curious
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <curl/curl.h>

#define CURL_RETRY_DELAY_AFTER_FAILURE 100L
#define MAX_RETRIES 3

typedef struct {
    CURL *curl;
    size_t size;
} fetch_t;

void die(const char *msg) {
    perror(msg);
    exit(1);
}

size_t writefunc(void *ptr, size_t size, size_t nmemb, void *stream) {
    size_t written = fwrite(ptr, size, nmemb, (FILE *) stream);
    return written;
}

fetch_t *fetch(const char *url) {
    fetch_t *ft = calloc(1, sizeof(fetch_t));

    if (!ft) die("calloc failed\n");
    ft->curl = curl_easy_init();

    if (!ft->curl) {
        free(ft);
        die("curl_easy_init failed\n");
    }

    curl_easy_setopt(ft->curl, CURLOPT_URL, url);
    curl_easy_setopt(ft->curl, CURLOPT_FOLLOWLOCATION, 1L);
    curl_easy_setopt(ft->curl, CURLOPT_WRITEFUNCTION, writefunc);
    curl_easy_setopt(ft->curl, CURLOPT_WRITEDATA, stdout);

    CURLcode res;
    int retries = 0;

    do {
        res = curl_easy_perform(ft->curl);
        if (res == CURLE_OK) {
            curl_easy_cleanup(ft->curl);
            free(ft);
            return NULL;
        }

        if (res != CURLE_OPERATION_TIMEDOUT && res != CURLE_RECV_ERROR) {
            fprintf(stderr, "Request failed: %s\n", curl_easy_strerror(res));
            break;
        }

        usleep(CURL_RETRY_DELAY_AFTER_FAILURE);
        retries++;

    } while (retries < MAX_RETRIES);

    curl_easy_cleanup(ft->curl);
    free(ft);

    fprintf(stderr, "Request failed: %s\n", curl_easy_strerror(res));
    return NULL;
}

int main() {
    const char *url = "https://example.com";
    fetch_t *ft = fetch(url);

    if (!ft) {
        fprintf(stderr, "Failed to fetch %s\n", url);
        return 1;
    }

    printf("Successfully fetched %s\n", url);
    free(ft);
    return 0;
}