//Falcon-180B DATASET v1.0 Category: Warehouse Management System ; Style: configurable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_WAREHOUSES 10
#define MAX_PRODUCTS 100

// Structure to hold information about the warehouse
typedef struct {
    char name[50];
    int capacity;
    int current_stock;
} Warehouse;

// Structure to hold information about the product
typedef struct {
    char name[50];
    int quantity;
    int price;
} Product;

// Function to initialize the warehouse
void init_warehouse(Warehouse *warehouse, char *name, int capacity) {
    strcpy(warehouse->name, name);
    warehouse->capacity = capacity;
    warehouse->current_stock = 0;
}

// Function to initialize the product
void init_product(Product *product, char *name, int quantity, int price) {
    strcpy(product->name, name);
    product->quantity = quantity;
    product->price = price;
}

// Function to add a product to the warehouse
void add_product(Warehouse *warehouse, Product *product) {
    if (warehouse->current_stock + product->quantity <= warehouse->capacity) {
        warehouse->current_stock += product->quantity;
        printf("Product added to warehouse: %s\n", product->name);
    } else {
        printf("Error: Warehouse is full.\n");
    }
}

// Function to remove a product from the warehouse
void remove_product(Warehouse *warehouse, Product *product) {
    if (warehouse->current_stock >= product->quantity) {
        warehouse->current_stock -= product->quantity;
        printf("Product removed from warehouse: %s\n", product->name);
    } else {
        printf("Error: Product not found in warehouse.\n");
    }
}

// Function to display the current stock of the warehouse
void display_stock(Warehouse *warehouse) {
    printf("Current stock in warehouse: %d\n", warehouse->current_stock);
}

int main() {
    Warehouse warehouse;
    Product product;

    // Initialize the warehouse
    init_warehouse(&warehouse, "Main Warehouse", 1000);

    // Initialize the product
    init_product(&product, "Product A", 50, 10);

    // Add the product to the warehouse
    add_product(&warehouse, &product);

    // Display the current stock of the warehouse
    display_stock(&warehouse);

    // Remove the product from the warehouse
    remove_product(&warehouse, &product);

    // Display the current stock of the warehouse
    display_stock(&warehouse);

    return 0;
}