//Falcon-180B DATASET v1.0 Category: Percolation Simulator ; Style: sophisticated
/* 
This program simulates a percolation system using a 2D grid. The grid starts with a random configuration of blocked and open cells. Water is then poured onto the top row of cells and allowed to percolate downward through the open cells. The program keeps track of the flow of water and displays the final configuration of the grid.
*/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define HEIGHT 10
#define WIDTH 10

int main() {
    int grid[HEIGHT][WIDTH]; // 2D grid to hold cell values
    int flow[HEIGHT][WIDTH]; // 2D grid to hold flow values
    int i, j; // loop variables

    // initialize grid with random values
    srand(time(NULL));
    for (i = 0; i < HEIGHT; i++) {
        for (j = 0; j < WIDTH; j++) {
            grid[i][j] = rand() % 2; // 0 = blocked, 1 = open
        }
    }

    // pour water onto top row of cells
    for (j = 0; j < WIDTH; j++) {
        flow[HEIGHT-1][j] = 1; // 1 = water
    }

    // simulate percolation
    for (i = HEIGHT-1; i >= 0; i--) {
        for (j = 0; j < WIDTH; j++) {
            if (i == HEIGHT-1) { // top row, flow water downward
                if (j > 0 && grid[i][j-1] == 1) {
                    flow[i][j] = flow[i][j-1];
                } else {
                    flow[i][j] = 0;
                }
            } else if (i == 0) { // bottom row, water flows out of grid
                if (j < WIDTH-1 && flow[i][j] == 1) {
                    flow[i][j+1] = flow[i][j];
                }
            } else { // middle rows, flow water downward
                if (j > 0 && grid[i][j-1] == 1 && flow[i][j-1] == 1) {
                    flow[i][j] = flow[i][j-1];
                } else {
                    flow[i][j] = 0;
                }
            }
        }
    }

    // display final configuration of grid
    for (i = 0; i < HEIGHT; i++) {
        for (j = 0; j < WIDTH; j++) {
            if (flow[i][j] == 1) {
                printf("*");
            } else {
                printf(" ");
            }
        }
        printf("\n");
    }

    return 0;
}