//GEMINI-pro DATASET v1.0 Category: Chess AI ; Style: decentralized
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

typedef struct {
    int x, y;
} Point;

typedef enum {
    WHITE,
    BLACK
} Color;

typedef struct {
    Color color;
    char type;
} Piece;

typedef struct {
    Piece pieces[8][8];
} Board;

void initBoard(Board *board) {
    for (int i = 0; i < 8; i++) {
        for (int j = 0; j < 8; j++) {
            board->pieces[i][j].color = (i == 1 || i == 6) ? BLACK : WHITE;
            switch (i) {
                case 0:
                case 7:
                    board->pieces[i][j].type = 'R';
                    break;
                case 1:
                case 6:
                    board->pieces[i][j].type = 'P';
                    break;
                case 2:
                case 5:
                    board->pieces[i][j].type = 'B';
                    break;
                case 3:
                    board->pieces[i][j].type = 'N';
                    break;
                case 4:
                    board->pieces[i][j].type = 'Q';
                    break;
                default:
                    board->pieces[i][j].type = 'K';
                    break;
            }
        }
    }
}

void printBoard(Board *board) {
    for (int i = 0; i < 8; i++) {
        for (int j = 0; j < 8; j++) {
            printf("%c", board->pieces[i][j].type);
        }
        printf("\n");
    }
}

int main() {
    Board board;
    initBoard(&board);
    printBoard(&board);
    return 0;
}