//Falcon-180B DATASET v1.0 Category: Appointment Scheduler ; Style: Sherlock Holmes
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_APPOINTMENTS 100
#define MAX_NAME_LENGTH 50

typedef struct {
    char name[MAX_NAME_LENGTH];
    time_t appointment_time;
    int is_solved;
} Appointment;

Appointment appointments[MAX_APPOINTMENTS];
int num_appointments = 0;

void add_appointment(char* name, time_t appointment_time) {
    if (num_appointments >= MAX_APPOINTMENTS) {
        printf("I'm afraid, Mr. Holmes, our schedule is quite full.\n");
        return;
    }

    strncpy(appointments[num_appointments].name, name, MAX_NAME_LENGTH);
    appointments[num_appointments].appointment_time = appointment_time;
    appointments[num_appointments].is_solved = 0;

    num_appointments++;
}

void list_appointments() {
    printf("Current appointments:\n");
    for (int i = 0; i < num_appointments; i++) {
        printf("%s - %s\n", appointments[i].name, ctime(&appointments[i].appointment_time));
    }
}

void solve_appointment(int index) {
    if (index >= num_appointments || appointments[index].is_solved) {
        printf("That case has already been solved, Watson.\n");
        return;
    }

    appointments[index].is_solved = 1;
    printf("The mystery of %s has been solved!\n", appointments[index].name);
}

int main() {
    add_appointment("The Adventure of the Speckled Band", 1443723200);
    add_appointment("The Mystery of the Yellow Room", 1443897600);

    list_appointments();

    solve_appointment(0);

    list_appointments();

    return 0;
}