//GPT-4o-mini DATASET v1.0 Category: Weather simulation ; Style: detailed
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define DAYS 7
#define MAX_TEMP 35
#define MIN_TEMP -10
#define MAX_HUMIDITY 100
#define MIN_HUMIDITY 0

typedef struct {
    int day;
    int temperature; // in degrees Celsius
    int humidity;    // in percentage
    char weather_description[20];
} Weather;

void generate_weather(Weather *weather) {
    // Randomly assign weather conditions
    weather->temperature = rand() % (MAX_TEMP - MIN_TEMP + 1) + MIN_TEMP;
    weather->humidity = rand() % (MAX_HUMIDITY - MIN_HUMIDITY + 1) + MIN_HUMIDITY;

    // Simple weather description based on temperature and humidity
    if (weather->temperature > 25 && weather->humidity < 50) {
        snprintf(weather->weather_description, sizeof(weather->weather_description), "Sunny");
    } else if (weather->temperature < 10) {
        snprintf(weather->weather_description, sizeof(weather->weather_description), "Cold");
    } else if (weather->humidity > 80) {
        snprintf(weather->weather_description, sizeof(weather->weather_description), "Rainy");
    } else {
        snprintf(weather->weather_description, sizeof(weather->weather_description), "Cloudy");
    }
}

void print_weather_report(Weather *weather) {
    printf("Day %d:\n", weather->day);
    printf("Temperature: %d°C\n", weather->temperature);
    printf("Humidity: %d%%\n", weather->humidity);
    printf("Weather Condition: %s\n", weather->weather_description);
    printf("----------------------\n");
}

void simulate_weather() {
    Weather weekly_weather[DAYS];
    srand(time(NULL));

    printf("7-Day Weather Forecast:\n");
    printf("=====================\n");
    
    for (int i = 0; i < DAYS; i++) {
        weekly_weather[i].day = i + 1;
        generate_weather(&weekly_weather[i]);
        print_weather_report(&weekly_weather[i]);
    }
}

int main() {
    simulate_weather();
    return 0;
}