//Falcon-180B DATASET v1.0 Category: Stock market tracker ; Style: surprised
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>

#define MAX_STOCKS 100
#define MAX_NAME_LEN 20
#define MAX_SYMBOL_LEN 10
#define MAX_PRICE_LEN 10
#define MAX_VOLUME_LEN 10
#define MAX_LAST_UPDATE_LEN 25

typedef struct {
    char name[MAX_NAME_LEN];
    char symbol[MAX_SYMBOL_LEN];
    char price[MAX_PRICE_LEN];
    char volume[MAX_VOLUME_LEN];
    time_t last_update;
} stock_t;

stock_t stocks[MAX_STOCKS];
int num_stocks = 0;

void add_stock(char* name, char* symbol, char* price, char* volume) {
    if (num_stocks >= MAX_STOCKS) {
        printf("Error: Maximum number of stocks reached.\n");
        return;
    }

    strcpy(stocks[num_stocks].name, name);
    strcpy(stocks[num_stocks].symbol, symbol);
    strcpy(stocks[num_stocks].price, price);
    strcpy(stocks[num_stocks].volume, volume);
    stocks[num_stocks].last_update = time(NULL);

    num_stocks++;
}

void print_stocks() {
    printf("\nStock Market Tracker\n");
    printf("=====================\n");

    printf("Name\tSymbol\tPrice\tVolume\tLast Update\n");
    for (int i = 0; i < num_stocks; i++) {
        printf("%-20s %-10s %-9s %-9s %s\n", stocks[i].name, stocks[i].symbol, stocks[i].price, stocks[i].volume, ctime(&stocks[i].last_update));
    }
}

int main() {
    add_stock("Apple Inc.", "AAPL", "145.68", "17.89M");
    add_stock("Microsoft Corporation", "MSFT", "263.78", "14.57M");
    add_stock("Amazon.com Inc.", "AMZN", "3459.88", "3.17M");

    print_stocks();

    return 0;
}