//Falcon-180B DATASET v1.0 Category: Building a HTTP Client ; Style: detailed
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <curl/curl.h>

// Callback function to handle incoming data
size_t WriteCallback(void *contents, size_t size, size_t nmemb, void *userp)
{
    ((char*)userp)[(size*nmemb)-1] = '\0';
    return size * nmemb;
}

// Callback function to handle errors
int DebugCallback(CURL *curl, curl_infotype type, char *data, size_t size, void *userp)
{
    if(type == CURLINFO_TEXT)
    {
        fprintf(stderr, "Debug: %s\n", data);
    }
    return 0;
}

int main(int argc, char* argv[])
{
    CURL *curl;
    CURLcode res;

    // Initialize curl
    curl_global_init(CURL_GLOBAL_DEFAULT);

    // Create curl handle
    curl = curl_easy_init();

    // Set URL to fetch
    char url[] = "https://jsonplaceholder.typicode.com/posts/1";

    // Set callback functions
    curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, WriteCallback);
    curl_easy_setopt(curl, CURLOPT_DEBUGFUNCTION, DebugCallback);

    // Set HTTP request method
    curl_easy_setopt(curl, CURLOPT_CUSTOMREQUEST, "GET");

    // Execute HTTP request
    res = curl_easy_perform(curl);

    // Check for errors
    if(res!= CURLE_OK)
    {
        fprintf(stderr, "curl_easy_perform() failed: %s\n", curl_easy_strerror(res));
    }

    // Cleanup curl
    curl_easy_cleanup(curl);

    // Close curl
    curl_global_cleanup();

    return 0;
}