//GPT-4o-mini DATASET v1.0 Category: Pixel Art Generator ; Style: complete
#include <stdio.h>
#include <stdlib.h>

#define WIDTH 20
#define HEIGHT 10

// Function to clear the console (works in Linux)
void clear() {
    printf("\033[H\033[J");
}

// Function to print pixel art
void printPixelArt(char canvas[HEIGHT][WIDTH]) {
    for (int y = 0; y < HEIGHT; y++) {
        for (int x = 0; x < WIDTH; x++) {
            // Use different symbols for different pixels
            char pixel = canvas[y][x];
            switch (pixel) {
                case ' ': printf(" "); break;      // Empty space
                case '#': printf("█"); break;      // Solid pixel
                case '.': printf("░"); break;      // Light pixel
                case 'o': printf("o"); break;      // Circle pixel
                case '@': printf("@"); break;      // Decorative pixel
                default:  printf(" "); break;
            }
        }
        printf("\n");
    }
}

// Function to initialize the canvas with blank spaces
void initCanvas(char canvas[HEIGHT][WIDTH]) {
    for (int y = 0; y < HEIGHT; y++) {
        for (int x = 0; x < WIDTH; x++) {
            canvas[y][x] = ' '; // Set all pixels as blank
        }
    }
}

// Function to create a simple heart shape
void createHeart(char canvas[HEIGHT][WIDTH]) {
    canvas[2][6] = '#'; 
    canvas[2][7] = '#'; 
    canvas[3][5] = '#'; 
    canvas[3][6] = '#'; 
    canvas[3][7] = '#'; 
    canvas[3][8] = '#'; 
    canvas[4][4] = '#'; 
    canvas[4][5] = '#'; 
    canvas[4][6] = '#'; 
    canvas[4][7] = '#'; 
    canvas[4][8] = '#'; 
    canvas[4][9] = '#'; 
    canvas[5][3] = '#'; 
    canvas[5][4] = '#'; 
    canvas[5][5] = '#'; 
    canvas[5][6] = '#'; 
    canvas[5][7] = '#'; 
    canvas[5][8] = '#'; 
    canvas[6][2] = '#'; 
    canvas[6][3] = '#'; 
    canvas[6][4] = '#'; 
    canvas[6][7] = '#'; 
    canvas[6][8] = '#'; 
}

// Main function
int main() {
    char canvas[HEIGHT][WIDTH];

    initCanvas(canvas);
    createHeart(canvas);

    clear();
    printPixelArt(canvas);

    // Await user input before exiting
    printf("Press enter to exit...");
    getchar();

    return 0;
}