//Falcon-180B DATASET v1.0 Category: Database querying ; Style: realistic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>

#define MAX_QUERY_LENGTH 1024
#define DATABASE_NAME "example.db"

// Function prototypes
int execute_query(sqlite3 *db, const char *query);
int create_table(sqlite3 *db);

int main() {
    sqlite3 *db;
    char *errMsg = NULL;

    // Open the database
    if (sqlite3_open(DATABASE_NAME, &db)!= SQLITE_OK) {
        fprintf(stderr, "Error opening database: %s\n", sqlite3_errmsg(db));
        sqlite3_close(db);
        return 1;
    }

    // Create table if it doesn't exist
    if (create_table(db)!= 0) {
        sqlite3_close(db);
        return 1;
    }

    // Insert sample data
    char insertQuery[MAX_QUERY_LENGTH] = "INSERT INTO example (name, age) VALUES ('John Doe', 30);";
    if (execute_query(db, insertQuery)!= 0) {
        sqlite3_close(db);
        return 1;
    }

    // Update sample data
    char updateQuery[MAX_QUERY_LENGTH] = "UPDATE example SET age = 31 WHERE name = 'John Doe';";
    if (execute_query(db, updateQuery)!= 0) {
        sqlite3_close(db);
        return 1;
    }

    // Retrieve data from table
    char selectQuery[MAX_QUERY_LENGTH] = "SELECT * FROM example;";
    if (execute_query(db, selectQuery)!= 0) {
        sqlite3_close(db);
        return 1;
    }

    // Close the database
    sqlite3_close(db);

    return 0;
}

int execute_query(sqlite3 *db, const char *query) {
    char *errMsg = NULL;
    int rc;

    // Execute the query
    rc = sqlite3_exec(db, query, NULL, NULL, &errMsg);

    // Check for errors
    if (rc!= SQLITE_OK) {
        fprintf(stderr, "Error executing query: %s\n", errMsg);
        sqlite3_free(errMsg);
        return 1;
    }

    return 0;
}

int create_table(sqlite3 *db) {
    char createTableQuery[MAX_QUERY_LENGTH] = "CREATE TABLE IF NOT EXISTS example (id INTEGER PRIMARY KEY, name TEXT, age INTEGER);";
    return execute_query(db, createTableQuery);
}