//Falcon-180B DATASET v1.0 Category: Robot movement control ; Style: happy
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <math.h>

#define PI 3.14159265358979323846

struct Vector2 {
    double x;
    double y;
};

struct Vector2 addVectors(struct Vector2 a, struct Vector2 b) {
    struct Vector2 result;
    result.x = a.x + b.x;
    result.y = a.y + b.y;
    return result;
}

struct Vector2 subtractVectors(struct Vector2 a, struct Vector2 b) {
    struct Vector2 result;
    result.x = a.x - b.x;
    result.y = a.y - b.y;
    return result;
}

double magnitude(struct Vector2 v) {
    return sqrt(pow(v.x, 2) + pow(v.y, 2));
}

double dotProduct(struct Vector2 a, struct Vector2 b) {
    return a.x * b.x + a.y * b.y;
}

struct Vector2 normalize(struct Vector2 v) {
    double mag = magnitude(v);
    struct Vector2 result;
    result.x = v.x / mag;
    result.y = v.y / mag;
    return result;
}

struct Vector2 rotate(struct Vector2 v, double theta) {
    struct Vector2 result;
    result.x = v.x * cos(theta) - v.y * sin(theta);
    result.y = v.x * sin(theta) + v.y * cos(theta);
    return result;
}

void moveRobot(double x, double y, double theta, double v, double w) {
    printf("Moving robot to position (%lf, %lf) with orientation %lf\n", x, y, theta);
    printf("Moving forward with speed %lf\n", v);
    printf("Turning left with speed %lf\n", w);
}

int main() {
    double x = 0.0, y = 0.0, theta = 0.0;
    double v = 1.0, w = 0.5;
    double t = 0.0;
    while (t < 10.0) {
        moveRobot(x, y, theta, v, w);
        x += v * cos(theta);
        y += v * sin(theta);
        theta += w;
        t += 1.0;
    }
    return 0;
}