//Falcon-180B DATASET v1.0 Category: Music Library Management System ; Style: excited
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_SONGS 100
#define MAX_TITLE_LEN 100
#define MAX_ARTIST_LEN 100

typedef struct {
    char title[MAX_TITLE_LEN];
    char artist[MAX_ARTIST_LEN];
    int duration;
} Song;

void addSong(Song* songs, int numSongs, char* title, char* artist, int duration) {
    if (numSongs >= MAX_SONGS) {
        printf("Error: Library is full!\n");
        return;
    }

    Song song = {
       .title = title,
       .artist = artist,
       .duration = duration
    };

    strcpy(songs[numSongs].title, title);
    strcpy(songs[numSongs].artist, artist);
    songs[numSongs].duration = duration;

    numSongs++;
}

void displaySongs(Song* songs, int numSongs) {
    printf("Library:\n");
    for (int i = 0; i < numSongs; i++) {
        printf("%d. %s - %s (%d seconds)\n", i+1, songs[i].title, songs[i].artist, songs[i].duration);
    }
}

int main() {
    Song library[MAX_SONGS];
    int numSongs = 0;

    addSong(library, numSongs, "Bohemian Rhapsody", "Queen", 180);
    addSong(library, numSongs, "Stairway to Heaven", "Led Zeppelin", 300);
    addSong(library, numSongs, "Imagine", "John Lennon", 120);

    displaySongs(library, numSongs);

    return 0;
}