//Falcon2-11B DATASET v1.0 Category: Chess engine ; Style: Ada Lovelace
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define WHITE 1
#define BLACK 2

typedef struct {
    int row;
    int col;
    int color;
} Piece;

void print_board(int board[8][8]);

void move_piece(int board[8][8], Piece piece, int row_dest, int col_dest);

int main() {
    int board[8][8] = {
        {0, 0, 0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 0, 0, 0, 0}
    };

    Piece black_pawn = {1, 2, BLACK};
    Piece white_pawn = {6, 4, WHITE};

    move_piece(board, white_pawn, 2, 3);
    print_board(board);

    move_piece(board, black_pawn, 1, 2);
    print_board(board);

    return 0;
}

void print_board(int board[8][8]) {
    for (int i = 0; i < 8; i++) {
        for (int j = 0; j < 8; j++) {
            if (board[i][j] == WHITE) {
                printf("W");
            } else if (board[i][j] == BLACK) {
                printf("B");
            } else {
                printf(" ");
            }
        }
        printf("\n");
    }
}

void move_piece(int board[8][8], Piece piece, int row_dest, int col_dest) {
    int row_src = piece.row;
    int col_src = piece.col;

    if (row_src == row_dest && col_src == col_dest) {
        return;
    }

    if (row_src == row_dest - 1 && col_src == col_dest) {
        board[row_src][col_src] = 0;
        board[row_dest][col_dest] = piece.color;
    } else if (row_src == row_dest + 1 && col_src == col_dest) {
        board[row_src][col_src] = 0;
        board[row_dest][col_dest] = piece.color;
    } else if (row_src == row_dest && col_src == col_dest - 1) {
        board[row_src][col_src] = 0;
        board[row_dest][col_dest] = piece.color;
    } else if (row_src == row_dest && col_src == col_dest + 1) {
        board[row_src][col_src] = 0;
        board[row_dest][col_dest] = piece.color;
    } else if (row_src == row_dest - 1 && col_src == col_dest - 1) {
        board[row_src][col_src] = 0;
        board[row_dest][col_dest] = piece.color;
    } else if (row_src == row_dest - 1 && col_src == col_dest + 1) {
        board[row_src][col_src] = 0;
        board[row_dest][col_dest] = piece.color;
    } else if (row_src == row_dest + 1 && col_src == col_dest - 1) {
        board[row_src][col_src] = 0;
        board[row_dest][col_dest] = piece.color;
    } else if (row_src == row_dest + 1 && col_src == col_dest + 1) {
        board[row_src][col_src] = 0;
        board[row_dest][col_dest] = piece.color;
    } else {
        printf("Invalid move!\n");
    }
}