//GPT-4o-mini DATASET v1.0 Category: Alien Invasion Probability Calculator ; Style: medieval
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Structure to represent the kingdom
typedef struct {
    char name[50];
    int population;
    int resources;
    int defense;
} Kingdom;

// Function declarations
void initializeKingdom(Kingdom *kingdom, char name[], int population, int resources, int defense);
void displayKingdomInfo(Kingdom kingdom);
float calculateInvasionProbability(Kingdom kingdom);

// Main function
int main() {
    // Declare the Kingdom
    Kingdom myKingdom;
    
    // Initialize the kingdom with values
    initializeKingdom(&myKingdom, "Eldoria", 5000, 700, 300);
    
    // Display the information about the kingdom
    displayKingdomInfo(myKingdom);
    
    // Calculate and display the probability of invasion
    float invasionProbability = calculateInvasionProbability(myKingdom);
    
    printf("The probability of alien invasion upon the kingdom of %s is: %.2f%%\n", myKingdom.name, invasionProbability);
    
    return 0;
}

// Function to initialize the kingdom
void initializeKingdom(Kingdom *kingdom, char name[], int population, int resources, int defense) {
    snprintf(kingdom->name, 50, "%s", name);
    kingdom->population = population;
    kingdom->resources = resources;
    kingdom->defense = defense;
}

// Function to display kingdom's information
void displayKingdomInfo(Kingdom kingdom) {
    printf("Welcome to the kingdom of %s!\n", kingdom.name);
    printf("Population: %d\n", kingdom.population);
    printf("Available Resources: %d\n", kingdom.resources);
    printf("Defense Strength: %d\n\n", kingdom.defense);
}

// Function to calculate the probability of alien invasion
float calculateInvasionProbability(Kingdom kingdom) {
    // We assume that more population and fewer resources increase risks
    // Defense decreases the probability while more population increases it
    float baseProbability = 10.0; // Base probability of invasion in percentage
    
    // Modify based on population density (hypothetical)
    float populationFactor = (float)kingdom.population / 1000.0; // Population part
    float resourceFactor = (100.0 - (float)kingdom.resources / 10.0); // Inverse of resources part
    float defenseFactor = (float)(100 - kingdom.defense) / 10.0; // Inverse of defense
    
    
    // Compiling all factors into the invasion probability
    float invasionChance = baseProbability + populationFactor - resourceFactor + defenseFactor;

    // Ensure that the probability does not exceed 100%
    if (invasionChance > 100.0) {
        invasionChance = 100.0;
    }
    
    // Ensure minimum probability is 0%
    if (invasionChance < 0) {
        invasionChance = 0;
    }
    
    return invasionChance;
}