//GEMINI-pro DATASET v1.0 Category: Network Packet Monitoring ; Style: automated
#include <pcap.h>
#include <stdio.h>
#include <stdlib.h>
#include <netinet/in.h>

/* Callback function for pcap_loop() */
void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    struct in_addr *addr;
    printf("Packet captured at %s\n", ctime((const time_t *) &header->ts.tv_sec));
    printf("Packet length: %d\n", header->len);

    /* Get the source IP address */
    addr = (struct in_addr *) (packet + 12);
    printf("Source IP: %s\n", inet_ntoa(*addr));

    /* Get the destination IP address */
    addr = (struct in_addr *) (packet + 16);
    printf("Destination IP: %s\n", inet_ntoa(*addr));

    /* Get the protocol type */
    printf("Protocol: ");
    switch (ntohs(*(u_short *) (packet + 9))) {
        case 1:
            printf("ICMP\n");
            break;
        case 6:
            printf("TCP\n");
            break;
        case 17:
            printf("UDP\n");
            break;
        default:
            printf("Unknown\n");
            break;
    }

    /* Print the first 16 bytes of the packet */
    printf("Packet data: ");
    for (int i = 0; i < 16; i++) {
        printf("%02x ", packet[i]);
    }
    printf("\n\n");
}

int main() {
    char *device = "en0";
    char *filter = "tcp port 80";
    int snaplen = 64;
    int promisc = 0;
    int timeout = 1000;

    /* Open the network device */
    pcap_t *handle = pcap_open_live(device, snaplen, promisc, timeout, NULL);
    if (handle == NULL) {
        perror("pcap_open_live");
        exit(1);
    }

    /* Set the filter */
    if (pcap_compile(handle, &filter, NULL, 0, 0) != 0) {
        perror("pcap_compile");
        exit(1);
    }
    if (pcap_setfilter(handle, &filter) != 0) {
        perror("pcap_setfilter");
        exit(1);
    }

    /* Start capturing packets */
    pcap_loop(handle, -1, packet_handler, NULL);

    /* Close the network device */
    pcap_close(handle);

    return 0;
}