//GPT-4o-mini DATASET v1.0 Category: Password Strength Checker ; Style: beginner-friendly
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#define PASSWORD_MIN_LENGTH 8
#define PASSWORD_MAX_LENGTH 20

// Function to check password strength
void check_password_strength(const char *password) {
    int length = strlen(password);
    int has_upper = 0, has_lower = 0, has_digit = 0, has_special = 0;
    const char *special_characters = "!@#$%^&*()-_=+[]{}|;:,.<>?/";

    // Check length constraint
    if (length < PASSWORD_MIN_LENGTH || length > PASSWORD_MAX_LENGTH) {
        printf("Password must be between %d and %d characters long.\n", PASSWORD_MIN_LENGTH, PASSWORD_MAX_LENGTH);
        return;
    }

    // Check for character types
    for (int i = 0; i < length; i++) {
        if (isupper(password[i])) {
            has_upper = 1;
        } else if (islower(password[i])) {
            has_lower = 1;
        } else if (isdigit(password[i])) {
            has_digit = 1;
        } else if (strchr(special_characters, password[i]) != NULL) {
            has_special = 1;
        }
    }

    // Summary of password strength
    if (has_upper && has_lower && has_digit && has_special) {
        printf("Your password is strong!\n");
    } else if ((has_upper || has_lower) && has_digit) {
        printf("Your password is moderate. Consider adding special characters.\n");
    } else {
        printf("Your password is weak. Consider using upper/lowercase letters, digits, and special characters.\n");
    }
}

// Main function
int main() {
    char password[PASSWORD_MAX_LENGTH + 1];

    // Get password from user
    printf("Enter your password (8-20 characters): ");
    fgets(password, sizeof(password), stdin);

    // Remove the newline character if it exists
    password[strcspn(password, "\n")] = 0;

    // Check password strength
    check_password_strength(password);

    return 0;
}