//GEMINI-pro DATASET v1.0 Category: Electronic Voting System ; Style: dynamic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum number of candidates and voters
#define MAX_CANDIDATES 10
#define MAX_VOTERS 100

// Define the structure of a candidate
typedef struct {
    char name[50];
    int votes;
} candidate_t;

// Define the structure of a voter
typedef struct {
    char name[50];
    int voted;
} voter_t;

// Declare the array of candidates
candidate_t candidates[MAX_CANDIDATES];

// Declare the array of voters
voter_t voters[MAX_VOTERS];

// Declare the number of candidates and voters
int num_candidates;
int num_voters;

// Declare the current voter
int current_voter;

// Function to initialize the voting system
void init_voting_system() {
    // Set the number of candidates to 0
    num_candidates = 0;

    // Set the number of voters to 0
    num_voters = 0;

    // Set the current voter to -1
    current_voter = -1;
}

// Function to add a candidate to the voting system
void add_candidate(char *name) {
    // Check if the number of candidates has reached the maximum
    if (num_candidates >= MAX_CANDIDATES) {
        printf("Error: Maximum number of candidates reached.\n");
        return;
    }

    // Copy the candidate's name to the array of candidates
    strcpy(candidates[num_candidates].name, name);

    // Set the candidate's votes to 0
    candidates[num_candidates].votes = 0;

    // Increment the number of candidates
    num_candidates++;
}

// Function to add a voter to the voting system
void add_voter(char *name) {
    // Check if the number of voters has reached the maximum
    if (num_voters >= MAX_VOTERS) {
        printf("Error: Maximum number of voters reached.\n");
        return;
    }

    // Copy the voter's name to the array of voters
    strcpy(voters[num_voters].name, name);

    // Set the voter's voted status to 0
    voters[num_voters].voted = 0;

    // Increment the number of voters
    num_voters++;
}

// Function to start the voting process
void start_voting() {
    // Set the current voter to 0
    current_voter = 0;

    // Print the list of candidates
    printf("Candidates:\n");
    for (int i = 0; i < num_candidates; i++) {
        printf("%d. %s\n", i + 1, candidates[i].name);
    }

    // Prompt the voter to enter their vote
    printf("Enter the number of the candidate you want to vote for: ");
}

// Function to cast a vote
void cast_vote(int candidate) {
    // Check if the candidate number is valid
    if (candidate < 1 || candidate > num_candidates) {
        printf("Error: Invalid candidate number.\n");
        return;
    }

    // Check if the voter has already voted
    if (voters[current_voter].voted) {
        printf("Error: You have already voted.\n");
        return;
    }

    // Increment the vote count for the selected candidate
    candidates[candidate - 1].votes++;

    // Set the voter's voted status to 1
    voters[current_voter].voted = 1;

    // Increment the current voter
    current_voter++;

    // Check if all voters have voted
    if (current_voter >= num_voters) {
        // Print the election results
        printf("Election Results:\n");
        for (int i = 0; i < num_candidates; i++) {
            printf("%s: %d votes\n", candidates[i].name, candidates[i].votes);
        }

        // Find the winning candidate
        int winning_candidate = 0;
        int max_votes = 0;
        for (int i = 0; i < num_candidates; i++) {
            if (candidates[i].votes > max_votes) {
                winning_candidate = i;
                max_votes = candidates[i].votes;
            }
        }

        // Print the winning candidate
        printf("The winner is: %s\n", candidates[winning_candidate].name);
    }
}

// Function to get the current voter's name
char *get_current_voter_name() {
    return voters[current_voter].name;
}

// Function to main
int main() {
    // Initialize the voting system
    init_voting_system();

    // Add some candidates to the voting system
    add_candidate("John Doe");
    add_candidate("Jane Doe");
    add_candidate("Bob Smith");

    // Add some voters to the voting system
    add_voter("Alice");
    add_voter("Bob");
    add_voter("Carol");

    // Start the voting process
    start_voting();

    // Cast some votes
    cast_vote(1);
    cast_vote(2);
    cast_vote(3);

    // Get the current voter's name
    char *current_voter_name = get_current_voter_name();

    // Print the current voter's name
    printf("Current voter: %s\n", current_voter_name);

    return 0;
}