//GEMINI-pro DATASET v1.0 Category: Bucket Sort Implementation ; Style: relaxed
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

// Function to sort an array using bucket sort
void bucketSort(int arr[], int n) {
  // Create an array of buckets
  int buckets[10] = {0};

  // Distribute elements into buckets
  for (int i = 0; i < n; i++) {
    int index = arr[i] / 10;
    buckets[index]++;
  }

  // Sort elements in each bucket
  for (int i = 0; i < 10; i++) {
    int count = buckets[i];
    while (count > 0) {
      for (int j = 0; j < n; j++) {
        if (arr[j] / 10 == i) {
          printf("%d ", arr[j]);
          count--;
        }
      }
    }
  }
}

// Driver code
int main() {
  int arr[] = {78, 90, 12, 77, 21, 56, 87, 45, 99, 63};
  int n = sizeof(arr) / sizeof(arr[0]);

  printf("Unsorted array: ");
  for (int i = 0; i < n; i++) {
    printf("%d ", arr[i]);
  }

  bucketSort(arr, n);

  printf("\nSorted array: ");
  for (int i = 0; i < n; i++) {
    printf("%d ", arr[i]);
  }

  printf("\n");

  return 0;
}