//GEMINI-pro DATASET v1.0 Category: Hotel Management System ; Style: sophisticated
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

struct Hotel {
    char name[50];
    char address[50];
    char phone[20];
    char email[50];
    int num_rooms;
    int num_available_rooms;
    float price_per_night;
};

struct Guest {
    char name[50];
    char address[50];
    char phone[20];
    char email[50];
    int num_nights;
    float total_cost;
};

struct Reservation {
    struct Guest guest;
    struct Hotel hotel;
    int check_in_date;
    int check_out_date;
};

void print_hotel(struct Hotel hotel) {
    printf("Hotel Name: %s\n", hotel.name);
    printf("Hotel Address: %s\n", hotel.address);
    printf("Hotel Phone: %s\n", hotel.phone);
    printf("Hotel Email: %s\n", hotel.email);
    printf("Number of Rooms: %d\n", hotel.num_rooms);
    printf("Number of Available Rooms: %d\n", hotel.num_available_rooms);
    printf("Price Per Night: %.2f\n", hotel.price_per_night);
}

void print_guest(struct Guest guest) {
    printf("Guest Name: %s\n", guest.name);
    printf("Guest Address: %s\n", guest.address);
    printf("Guest Phone: %s\n", guest.phone);
    printf("Guest Email: %s\n", guest.email);
    printf("Number of Nights: %d\n", guest.num_nights);
    printf("Total Cost: %.2f\n", guest.total_cost);
}

void print_reservation(struct Reservation reservation) {
    printf("Guest:\n");
    print_guest(reservation.guest);
    printf("Hotel:\n");
    print_hotel(reservation.hotel);
    printf("Check-In Date: %d\n", reservation.check_in_date);
    printf("Check-Out Date: %d\n", reservation.check_out_date);
}

int main() {
    struct Hotel hotel = {
        .name = "Grand Hotel",
        .address = "123 Main Street",
        .phone = "555-1212",
        .email = "info@grandhotel.com",
        .num_rooms = 100,
        .num_available_rooms = 50,
        .price_per_night = 100.00
    };

    struct Guest guest = {
        .name = "John Smith",
        .address = "123 Elm Street",
        .phone = "555-1213",
        .email = "john.smith@example.com",
        .num_nights = 3,
        .total_cost = 300.00
    };

    struct Reservation reservation = {
        .guest = guest,
        .hotel = hotel,
        .check_in_date = 20230301,
        .check_out_date = 20230304
    };

    print_reservation(reservation);

    return 0;
}