//Gemma-7B DATASET v1.0 Category: Cafe Billing System ; Style: random
#include <stdio.h>
#include <stdlib.h>

// Define the maximum number of items that can be ordered
#define MAX_ITEMS 10

// Define the structure of an item
typedef struct Item
{
    char name[20];
    int quantity;
    float price;
} Item;

// Create an array of items
Item items[MAX_ITEMS];

// Function to add an item to the array
void addItem(char name, int quantity, float price)
{
    int i = 0;
    for (; i < MAX_ITEMS && items[i].name[0] != '\0'; i++)
    {
    }

    items[i].name[0] = '\0';
    strcpy(items[i].name, name);
    items[i].quantity = quantity;
    items[i].price = price;
}

// Function to calculate the total cost of an order
float calculateTotalCost()
{
    int i = 0;
    float totalCost = 0.0;
    for (; items[i].name[0] != '\0'; i++)
    {
        totalCost += items[i].quantity * items[i].price;
    }

    return totalCost;
}

// Function to print the bill
void printBill()
{
    int i = 0;
    printf("------------------------\n");
    printf("Coffee House Bill\n");
    printf("------------------------\n");
    printf("Items:\n");
    for (; items[i].name[0] != '\0'; i++)
    {
        printf("%s - %d @ %.2f\n", items[i].name, items[i].quantity, items[i].price);
    }

    printf("\nTotal Cost: %.2f\n", calculateTotalCost());
    printf("------------------------\n");
    printf("Thank you for your visit!\n");
    printf("------------------------\n");
}

int main()
{
    // Add items to the array
    addItem("Coffee", 2, 2.50);
    addItem("Tea", 1, 1.50);
    addItem("Juice", 3, 1.20);

    // Print the bill
    printBill();

    return 0;
}