//Falcon-180B DATASET v1.0 Category: Stock market tracker ; Style: curious
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#define MAX_STOCKS 100
#define MAX_NAME_LENGTH 20

typedef struct {
    char name[MAX_NAME_LENGTH];
    double price;
} Stock;

Stock stocks[MAX_STOCKS];
int num_stocks = 0;

void add_stock(char* name, double price) {
    strcpy(stocks[num_stocks].name, name);
    stocks[num_stocks].price = price;
    num_stocks++;
}

void remove_stock(int index) {
    if (index >= 0 && index < num_stocks) {
        num_stocks--;
        for (int i = index; i < num_stocks; i++) {
            strcpy(stocks[i].name, stocks[i+1].name);
            stocks[i].price = stocks[i+1].price;
        }
    } else {
        printf("Invalid stock index.\n");
    }
}

void update_stock_price(int index, double price) {
    if (index >= 0 && index < num_stocks) {
        stocks[index].price = price;
    } else {
        printf("Invalid stock index.\n");
    }
}

void print_stocks() {
    for (int i = 0; i < num_stocks; i++) {
        printf("%s: $%.2f\n", stocks[i].name, stocks[i].price);
    }
}

int main() {
    add_stock("Apple", 500.00);
    add_stock("Google", 1000.00);
    add_stock("Microsoft", 200.00);

    print_stocks();

    remove_stock(1);

    print_stocks();

    update_stock_price(0, 600.00);

    print_stocks();

    return 0;
}