//Falcon-180B DATASET v1.0 Category: Socket programming ; Style: complete
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <errno.h>

#define MAX 100

// Function to handle errors
void error_handling(char *message) {
    perror(message);
    exit(0);
}

// Function to create socket
int create_socket() {
    int sockfd;
    if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
        error_handling("socket failed");
    }
    return sockfd;
}

// Function to connect to server
int connect_to_server(int sockfd, struct sockaddr_in server) {
    if (connect(sockfd, (struct sockaddr*)&server, sizeof(struct sockaddr_in)) == -1) {
        error_handling("connection failed");
    }
    return sockfd;
}

// Function to send data to server
int send_data(int sockfd, char *buffer) {
    if (send(sockfd, buffer, strlen(buffer), 0) == -1) {
        error_handling("send failed");
    }
    return sockfd;
}

// Function to receive data from server
int receive_data(int sockfd, char *buffer) {
    if (recv(sockfd, buffer, MAX, 0) == -1) {
        error_handling("recv failed");
    }
    return sockfd;
}

// Function to close socket
int close_socket(int sockfd) {
    if (close(sockfd) == -1) {
        error_handling("socket close failed");
    }
    return 0;
}

// Main function
int main() {
    int sockfd;
    struct sockaddr_in server;
    char buffer[MAX];

    // Create socket
    sockfd = create_socket();

    // Initialize server address
    server.sin_family = AF_INET;
    server.sin_port = htons(8080);
    inet_pton(AF_INET, "127.0.0.1", &server.sin_addr);

    // Connect to server
    sockfd = connect_to_server(sockfd, server);

    // Send data to server
    strcpy(buffer, "Hello, World!");
    sockfd = send_data(sockfd, buffer);

    // Receive data from server
    sockfd = receive_data(sockfd, buffer);
    printf("Received data: %s\n", buffer);

    // Close socket
    close_socket(sockfd);

    return 0;
}