//MISTRAL-7B DATASET v1.0 Category: Text to ASCII art generator ; Style: authentic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define WIDTH 40
#define HEIGHT 4

typedef struct {
    char symbol;
    int x, y;
} Fig;

const Fig figures[] = {
    {'@', 1, 1}, {'%', 2, 1}, {'+', 3, 1}, {'*', 1, 2}, {'=', 2, 2}, {'-', 3, 2}, {'|', 1, 3}, {'/', 2, 3}, {'\\', 3, 3}
};

void print_figure(const Fig *fig) {
    int i, j;

    for (i = 0; i < HEIGHT; i++) {
        for (j = 0; j < WIDTH; j++) {
            if (j < fig->x || j >= fig->x + WIDTH || i < fig->y || i >= fig->y + HEIGHT)
                putchar(' ');
            else
                putchar(fig->symbol);
        }
        putchar('\n');
    }
}

void generate_ascii_art(const char *text) {
    int len = strlen(text);
    int i, j, fig_idx;
    Fig fig;

    for (i = 0; i < len; i++) {
        switch (tolower(text[i])) {
            case '@':
                fig = figures[0];
                break;
            case '%':
                fig = figures[1];
                break;
            case '+':
                fig = figures[2];
                break;
            case '*':
                fig = figures[5];
                break;
            case '-':
                fig = figures[6];
                break;
            case '|':
                fig = figures[8];
                break;
            case '/':
                fig = figures[9];
                break;
            default:
                continue;
        }

        fig_idx = i / WIDTH;
        j = i % WIDTH;

        fig.x = j;
        fig.y = fig_idx;

        print_figure(&fig);
    }
}

int main() {
    const char *text = "The quick brown fox jumps over the lazy dog.";

    printf("\n");
    generate_ascii_art(text);

    return 0;
}